function bindTooltip(name, contentCallback)
{
	$(name).bind("plothover", function (event, pos, item) {
        $("#x").text(pos.x.toFixed(2));
        $("#y").text(pos.y.toFixed(2));

		if (item) {
      if(typeof previousPoint === 'undefined' || previousPoint === null)
      {
        previousPoint = (-1, -1);
      }
			if (previousPoint != item.dataIndex) {
				previousPoint = item.dataIndex;

				$("#tooltip").remove();
				var x = item.datapoint[0].toFixed(2),
					y = item.datapoint[1].toFixed(2);

				showTooltip(item.pageX, item.pageY, contentCallback(x, y));
			}
		}
		else {
			$("#tooltip").remove();
			previousPoint = null;
		}
    });
}

$.fn.textWidth = function textWidth(text) {
		if (!$.fn.textWidth.fakeEl)
		 	$.fn.textWidth.fakeEl = $('<span>').hide().appendTo(document.body);
		$.fn.textWidth.fakeEl.text(text || this.val() || this.text()).css(this.css('font') || 'font', '13px arial');
		return $.fn.textWidth.fakeEl.width();
};

function showTooltip(x, y, contents) {
	var txtWidth = $.fn.textWidth(contents);
	var neededWidth = x + txtWidth;
	var leftPos = x + 5;
	var windowWidth = $(window).width();
	if(neededWidth > windowWidth)
		leftPos = windowWidth - txtWidth - 5;
	$('<div id="tooltip">' + contents + '</div>').css( {
		position: 'absolute',
		display: 'none',
		top: y + 5,
		left: leftPos,
		border: '1px solid #fdd',
		padding: '2px',
		backgroundColor: '#FFFFFF',
		color: '#01304D',
		opacity: 0.90
	}).appendTo("body").fadeIn(200);
}
