/*global FastClick */
(function () {
  'use strict';

  $(document).ready(function () {

    // activate FastClick
    FastClick.attach(document.body);

    // set global properties for psol JS API
    //psol.core.setServiceBaseUrl('');
    psol.core.addGlobalHttpHeader('PortalState', 'LIVE');
    psol.core.addGlobalHttpHeader('Portal', 'oem_apps_cadenas_cad_models');
    psol.core.addGlobalHttpHeader('appname', 'oem_apps_cadenas_cad_models');

    // set global properties for psol.components JS API
    psol.components.componentsPath = './';


    function emptyFilter() {
      $('.filterInput').val('');
    }


    // create an FilterAssistant component
    var filterAssistant = new psol.components.FilterAssistant();

    // settings for the component
    var settings = {
      container: $('.componentContainer'),
      useRetinaImages: false
    };

    // initialize the component with the settings
    filterAssistant.init(settings);

    // progress handling
    filterAssistant.onProgressBegin = function (title, text) {
      return $.Deferred().resolve();
    };

    filterAssistant.onProgressEnd = function () {

    };

    // show the component
    filterAssistant.show().done(function () {

      // when the container element get a resize event then tell this the component
      // (this only works with a jquery.resize Plugin)
      $('.componentContainer').resize(function () {
        filterAssistant.resizeContainer();
      });

      // load a path to the index component
      filterAssistant.loadByPath(window.location.search.match(/prj=[^&]*/)[0].split('=')[1]);

      filterAssistant.onSearchClicked = function (event) {
        submitSearch(event.data);
      };

      filterAssistant.onResetClicked = function (event) {
        filterAssistant.loadByPath(event.data);
      };
    });
  });
}());
