brite.viewDefaultConfig.loadTmpl = true;
brite.viewDefaultConfig.loadCss = true;
function render(templateName, data) {
  var tmpTmplName = templateName;
  if(/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)) {
    tmpTmplName += "_mobile";
    if($("#" + tmpTmplName).length === 0) {
      tmpTmplName = templateName
    }
  }
  var tmpl = $.templates[tmpTmplName];
  if(!tmpl) {
    $.templates(tmpTmplName, "#" + tmpTmplName);
    tmpl = $.templates[tmpTmplName]
  }
  return tmpl.render(data)
}
$.views.helpers({zTr:function zTr(value) {
  return psol.translation.translate(value, [], psol.core.getLanguage())
}});
var main = main || {};
(function() {
  main.getParameterByName = function(paramName) {
    var match = (new RegExp(paramName + "=([^&]*)")).exec(window.location.search);
    return match && decodeURIComponent(match[1].replace(/\+/g, " "))
  };
  main.isMobile = function() {
    if(/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)) {
      return true
    }
    return false
  };
  main.getTableData = function(changeData) {
    var changeVar = null;
    var changeValue = null;
    if(changeData) {
      changeVar = changeData.changeVar;
      changeValue = changeData.changeValue
    }
    var varsetTransfer = null;
    if(main.tableData.index) {
      varsetTransfer = main.tableData.index.varsettransfer
    }
    main.tableScroll = $(".main_view-table").scrollTop();
    return $.ajax({url:main.TABLE_SERVICE, type:"POST", dataType:"json", data:{path:main.prjPath, language:main.language, varsettransfer:varsetTransfer, changevar:changeVar, changeval:changeValue, showall:true, showma:true, showerp:false}})
  };
  main.TABLE_SERVICE = "/service/table";
  console.warn("!!!!/service/search only temporary until JUST fixes his pappserver - change to psol API");
  main.SEARCH_URL = "/service/search";
  main.language = main.getParameterByName("language");
  main.prjPath = main.getParameterByName("prj");
  main.tableData = {};
  main.hasTechviews = true;
  main.tableScroll = 0;
  main.init = function() {
    psol.ui.setUITemplateBaseFolder("tmpl/");
    psol.ui.initialize().done(function() {
      psol.translation.getTranslationByUrlAsync("translation/translate.json").always(function() {
        brite.display("main_view", "#pageBody")
      })
    })
  }
})();
$(document).ready(function() {
  main.init()
});
(function() {
  brite.registerView("main_view", {emptyParent:true}, {create:function(data) {
    return render("tmpl-main_view")
  }, postDisplay:function() {
    var view = this;
    main.getTableData().done(function(data) {
      main.tableData = data;
      $(".main_view-header").html(render("tmpl-main_view-header", {title:data.index.NN, subtitle:data.index.NT}));
      brite.display("table_view", $(".main_view-table"));
      brite.display("techviews_view", $(".main_view-techview"))
    })
  }, events:{"click; .main_view-search >button":function(event) {
    var columns = main.tableData.index.line.values;
    submitSearch(columns.SEARCHPATH.current, columns.SEARCH.current)
  }}, docEvents:{"TABLE_VALUE_CHANGE":function(event, changeData) {
    var view = this;
    main.getTableData(changeData).done(function(data) {
      main.tableData = data;
      var table = view.$el.find(".main_view-table").bEmpty();
      brite.display("table_view", table)
    })
  }, "HIDE_TECHVIEW":function(event) {
    $(".main_view-techview").hide()
  }}, winEvents:{"resize":function(event) {
    var tableHeight = 0;
    var padding = $(".main_view").innerHeight() - $(".main_view").height();
    if(main.hasTechviews) {
      tableHeight = window.innerHeight - ($(".main_view-header").outerHeight(true) + $(".main_view-techview").outerHeight(true) + $(".main_view-search").outerHeight(true) + padding)
    }else {
      tableHeight = window.innerHeight - ($(".main_view-header").outerHeight(true) + $(".main_view-search").outerHeight(true) + padding)
    }
    $(".main_view-table").outerHeight(tableHeight, true)
  }}})
})();
(function() {
  var _view;
  brite.registerView("table_view", {create:function(data) {
    return render("tmpl-table_view")
  }, postDisplay:function() {
    _view = this;
    var line = main.tableData.index.line;
    if(parseInt(line.nr, 10) !== -1) {
      refreshTable.call(_view, line)
    }
  }, events:{"blur; .table_view-slider-inputTd >input":function(event) {
    var id = $(event.currentTarget).bEntity("Slider").id;
    var value = parseFloat($("#sliderVal_" + id).val());
    if(parseFloat(main.tableData.index.line.values[id].current) !== value) {
      this.$el.trigger("TABLE_VALUE_CHANGE", {changeVar:id, changeValue:value})
    }
  }, "keyup; .table_view-slider-inputTd >input":function(event) {
    var $target = $(event.currentTarget), value = $target.val().replace(/,/, "."), sliderData = $("#slider_" + $target.bEntity("Slider").id).slider().data("slider");
    if(isNaN(value)) {
      if(!(sliderData.min < 0 && (value.length === 1 && value === "-"))) {
        $target.val(value.substring(0, value.length - 1))
      }
    }
  }, "slide; .table_view-slider-sliderTd >div":function(event) {
    var id = $(event.currentTarget).bEntity("Slider").id;
    var $slider = $("#slider_" + id);
    var value = $slider.slider().data("slider").getValue();
    var $inputField = $("#sliderVal_" + id).val(parseFloat(value.toFixed(5)))
  }, "slideStop; .table_view-slider-sliderTd >div":function(event) {
    var targetId = $(event.currentTarget).bEntity("Slider").id;
    $("#sliderVal_" + targetId).trigger("blur")
  }}});
  function dropDownSelected(data) {
    console.log(data);
    var id = data.attr("id");
    var value = data.find("option:selected").val();
    _view.$el.trigger("TABLE_VALUE_CHANGE", {changeVar:id, changeValue:value})
  }
  function refreshTable(line) {
    var sortedColumns = getSortedColumns(line.values);
    var searchFound = false;
    var even = true;
    $.each(sortedColumns, function(idx, column) {
      if(column.name === "SEARCH") {
        searchFound = true
      }
      if(!column.isHidden) {
        $.extend(column, {even:even});
        if(!searchFound) {
          if(column.status === "" || (column.status === "static" || (column.status === "fixed" || column.status === "finished"))) {
            if(column.values && column.values.length > 1) {
              _view.$el.append(render("tmpl-table_view-dropdown", $.extend(column, {imgBasePath:main.tableData.index.imgbasepath + "?previewPath="})))
            }else {
              if(column.current !== "") {
                _view.$el.append(render("tmpl-table_view-textbox", column))
              }
            }
          }else {
            if(column.status === "ranged") {
              createSlider(_view, column)
            }
          }
        }else {
          var table = _view.$el.find(".table_view-infobox-table");
          if(!table.length) {
            table = _view.$el.append(render("tmpl-table_view-infobox", {even:even})).find(".table_view-infobox-table")
          }
          table.append(render("tmpl-table_view-infoboxItem", column))
        }
        even = !even
      }
    });
    $("select").each(function() {
      $(this).psolDropDown({onSelected:dropDownSelected})
    });
    _view.$el.parent().scrollTop(main.tableScroll)
  }
  function createSlider(viewObj, column) {
    var view = viewObj;
    if(column.step === 0) {
      if(!column.prec) {
        column.prec = 3
      }
      column.step = 1 / Math.pow(10, column.prec)
    }
    if(column.mininc && column.mininc === false) {
      column.min += column.step
    }
    if(column.maxinc && column.maxinc === false) {
      column.max -= column.step
    }
    view.$el.append(render("tmpl-table_view-slider", column));
    var $slider = $("#slider_" + column.name);
    $slider.slider()
  }
  function sortByOrderNr(obja, objb) {
    if(obja.order === objb.order) {
      return 0
    }else {
      if(obja.order > objb.order) {
        return 1
      }
    }
    return-1
  }
  function getSortedColumns(columns) {
    var sortedColumns = [];
    var resultCols = [];
    var i;
    for(i in columns) {
      if(columns.hasOwnProperty(i)) {
        columns[i].name = i;
        if(columns[i].isResult) {
          resultCols.push(columns[i])
        }else {
          sortedColumns.push(columns[i])
        }
      }
    }
    sortedColumns.sort(sortByOrderNr);
    $.merge(sortedColumns, resultCols);
    return sortedColumns
  }
})();
(function() {
  brite.registerView("techviews_view", {create:function(data) {
    var view = this;
    return render("tmpl-techviews_static")
  }, postDisplay:function() {
    var view = this;
    psol.index.getTechViewsAsync({mident:"{" + main.tableData.index.path + "}", path:main.tableData.index.path}).always(function(data) {
      $.extend(techviewData, data, {title:"Technische Ansichten", title2:"Technische Ansicht"});
      $("#techview_container").html(render("tmpl-techviews_view", techviewData));
      if(techviewData.views && techviewData.views.length > 0) {
        setTechviewSize.call(view);
        view.$el.find(".techviews_view-image").on("load", function() {
          setTechviewSize.call(view)
        })
      }else {
        view.$el.trigger("HIDE_TECHVIEW");
        main.hasTechviews = false
      }
      view.$el.trigger("resize")
    })
  }, events:{"click; .techviews_view-controls-right":function(event) {
    switchTechview.call(this, true)
  }, "click; .techviews_view-controls-left":function(event) {
    switchTechview.call(this, false)
  }}, winEvents:{"resize":function(event) {
    if(main.hasTechviews) {
      setTechviewSize.call(this)
    }
  }}});
  var techviewData = {};
  function setTechviewSize() {
    var view = this;
    var image = view.$el.find(".techviews_view-image");
    var ratio = image.get(0).naturalWidth / image.get(0).naturalHeight;
    var maxHeight = view.$el.height() - view.$el.find(".techviews_view-title").outerHeight(true);
    var maxWidth = view.$el.width();
    var width = maxWidth;
    var height = width / ratio;
    if(height > maxHeight) {
      height = maxHeight;
      width = height * ratio
    }
    view.$el.find(".techviews_view-imageBox").outerWidth(width);
    view.$el.find(".techviews_view-imageBox").outerHeight(height)
  }
  function switchTechview(isNext) {
    var view = this;
    var currentIdx = parseInt(view.$el.attr("currentIdx"));
    var viewCount = techviewData.views.length;
    if(isNext) {
      currentIdx = currentIdx + 1 < viewCount ? currentIdx + 1 : 0
    }else {
      currentIdx = currentIdx - 1 >= 0 ? currentIdx - 1 : viewCount - 1
    }
    var image = view.$el.find(".techviews_view-image");
    image.attr("src", techviewData.views[currentIdx].dataUrl);
    view.$el.find("#techviewIdx").html(currentIdx + 1);
    view.$el.attr("currentIdx", currentIdx)
  }
})();

