let CACHE_NAME = '3df-pwa';
let OFFLINE_URL = 'offline.html';
let urlsToCache = [OFFLINE_URL, 'favicon.ico', 'title.svg'];

// Install service worker
self.addEventListener('install', (event) => {
  // Perform the install steps
  event.waitUntil(
    caches
      .open(CACHE_NAME)
      .then(async (cache) => {
        return cache.addAll(urlsToCache);
      })
      // For updating the sw: skip the waiting phase and become immediately activated.
      // This overrides all old sw in all open tabs.
      // Important: the user should be informed that he needs to reload the page.
      // Otherwise the user may navigate on old UI with new code, which may cause trouble.
      .then(self.skipWaiting())
  );
});

// Cache and return the requests
self.addEventListener('fetch', (event) => {
  if (event.request.mode === 'navigate' && event.request.referrer) {
    return;
  }
  if (event.request.mode === 'navigate' || (event.request.method === 'GET' && event.request.headers.get('accept').includes('text/html'))) {
    event.respondWith(
      fetch(event.request).catch(async function () {
        return caches.open(CACHE_NAME).then(async function (cache) {
          return cache.match(OFFLINE_URL);
        });
      })
    );
  } else {
    event.respondWith(
      caches.match(event.request).then((response) => {
        // Return response as Cache is hit, otherwise request network
        return (
          response ||
          fetch(event.request).catch(async (error) => {
            return Promise.resolve(
              new Response(`<h1>Service Unavailable</h1><p>${error}</p>`, {
                status: 503,
                statusText: 'Service Unavailable',
                headers: new Headers({
                  'Content-Type': 'text/html',
                }),
              })
            );
          })
        );
      })
    );
  }
});

// Update service worker
self.addEventListener('activate', (event) => {
  let cacheWhitelist = [CACHE_NAME];
  event.waitUntil(
    caches.keys().then(async (cacheNames) => {
      return Promise.all(
        cacheNames.map(async (cacheName) => {
          if (cacheWhitelist.indexOf(cacheName) === -1) {
            return caches.delete(cacheName);
          }
        })
      );
    })
  );
});
