
function CharacteristicChart() {
  
  this.currentChart = null;
    
  this.init = function () {    

  }
  
  // type: enum SampleType { Linear = 0, Stepped = 1, Cubic = 2, Hole = 3 };
  this.setData = function (data, animate) {
    
    var dataJson = JSON.parse(data);
    
    var xAxisName = "";
    var yAxisName = "";
    
    var labels = []
    var dataSets = []
    for(var lineData in dataJson.data) {
      var line = dataJson.data[lineData]
      var dataSet = {};      
      dataSet["label"] = line.name;
      dataSet["backgroundColor"] = 'rgb(255, 99, 132)';
      dataSet["borderColor"] = 'rgb(255, 99, 132)';
      dataSet["data"] = [];
      for(var sample in line.samples) {
        var sampleData = line.samples[sample];
        
        labels.push(sampleData.x.toString())
        if(sampleData.type==3) { // Hole
          dataSet["data"].push("NaN");
        } else {
          dataSet["data"].push(sampleData.y);
        }
      }
      
      if(line.type==0) {
        // Nothing to do
      } else if(line.type==1) {
        dataSet["stepped"] = true;
      } else if(line.type==2) {
        dataSet["cubicInterpolationMode"] = 'monotone';
        dataSet["tension"] = 0.4;
      }
      
      if(line.xName!=="") {
        xAxisName = line.xName;
      }
      
      if(line.yName!=="") {
        yAxisName = line.yName;
      }
      
      dataSets.push(dataSet);
    }
    
    var options = {}
    
    if(animate!==false) {
      options["animation"] = false;
    }
    
    
    if(xAxisName!=="" || yAxisName!=="") {
      options.scales = {};
    }
    
    if(xAxisName!=="") {      
      options.scales.x = {};
      options.scales.x.display = true;
      options.scales.x.title = {};
      options.scales.x.title.display = true;
      options.scales.x.title.text = xAxisName;
    }
    
    if(yAxisName!=="") {
      options.scales.y = {};
      options.scales.y.display = true;
      options.scales.y.title = {};
      options.scales.y.title.display = true;
      options.scales.y.title.text = yAxisName;
    }
    
    const config = {
      type: 'line',
      data: {
        labels: labels,
        datasets: dataSets
      },
      options: options
    };
    
    if(this.currentChart!==null && this.currentChart!==undefined) {
      this.currentChart.destroy();
      this.currentChart = null;
    }
    
    this.currentChart = new Chart(
      document.getElementById('chartCanvas'),
      config
    );
  }
}

var charChart;
var charData;
var doAnimation;
$(document).ready(function () {
  charChart = new CharacteristicChart();
  charChart.init();
  if(charData!==undefined) {
    charChart.setData(charData, doAnimation);
  }
});

function setData(data, animate) {
  if(charChart!==undefined) {
    charChart.setData(data, animate);
  } else {
    charData = data;
    doAnimation = animate;
  }
}