**LevelDB is a fast key-value storage library written at Google that provides an ordered mapping from string keys to string values.**\\n\\n[![Build Status](https://travis-ci.org/google/leveldb.svg?branch=master)](https://travis-ci.org/google/leveldb)\\n[![Build status](https://ci.appveyor.com/api/projects/status/g2j5j4rfkda6eyw5/branch/master?svg=true)](https://ci.appveyor.com/project/pwnall/leveldb)\\n\\nAuthors: Sanjay Ghemawat (sanjay@google.com) and Jeff Dean (jeff@google.com)\\n\\n# Features\\n\\n  * Keys and values are arbitrary byte arrays.\\n  * Data is stored sorted by key.\\n  * Callers can provide a custom comparison function to override the sort order.\\n  * The basic operations are `Put(key,value)`, `Get(key)`, `Delete(key)`.\\n  * Multiple changes can be made in one atomic batch.\\n  * Users can create a transient snapshot to get a consistent view of data.\\n  * Forward and backward iteration is supported over the data.\\n  * Data is automatically compressed using the [Snappy compression library](https://google.github.io/snappy/).\\n  * External activity (file system operations etc.) is relayed through a virtual interface so users can customize the operating system interactions.\\n\\n# Documentation\\n\\n  [LevelDB library documentation](https://github.com/google/leveldb/blob/master/doc/index.md) is online and bundled with the source code.\\n\\n# Limitations\\n\\n  * This is not a SQL database.  It does not have a relational data model, it does not support SQL queries, and it has no support for indexes.\\n  * Only a single process (possibly multi-threaded) can access a particular database at a time.\\n  * There is no client-server support builtin to the library.  An application that needs such support will have to wrap their own server around the library.\\n\\n# Getting the Source\\n\\n```bash\\ngit clone --recurse-submodules https://github.com/google/leveldb.git\\n```\\n\\n# Building\\n\\nThis project supports [CMake](https://cmake.org/) out of the box.\\n\\n### Build for POSIX\\n\\nQuick start:\\n\\n```bash\\nmkdir -p build && cd build\\ncmake -DCMAKE_BUILD_TYPE=Release .. && cmake --build .\\n```\\n\\n### Building for Windows\\n\\nFirst generate the Visual Studio 2017 project/solution files:\\n\\n```cmd\\nmkdir build\\ncd build\\ncmake -G \\\"Visual Studio 15\\\" ..\\n```\\nThe default default will build for x86. For 64-bit run:\\n\\n```cmd\\ncmake -G \\\"Visual Studio 15 Win64\\\" ..\\n```\\n\\nTo compile the Windows solution from the command-line:\\n\\n```cmd\\ndevenv /build Debug leveldb.sln\\n```\\n\\nor open leveldb.sln in Visual Studio and build from within.\\n\\nPlease see the CMake documentation and `CMakeLists.txt` for more advanced usage.\\n\\n# Contributing to the leveldb Project\\n\\nThe leveldb project welcomes contributions. leveldb's primary goal is to be\\na reliable and fast key/value store. Changes that are in line with the\\nfeatures/limitations outlined above, and meet the requirements below,\\nwill be considered.\\n\\nContribution requirements:\\n\\n1. **Tested platforms only**. We _generally_ will only accept changes for\\n   platforms that are compiled and tested. This means POSIX (for Linux and\\n   macOS) or Windows. Very small changes will sometimes be accepted, but\\n   consider that more of an exception than the rule.\\n\\n2. **Stable API**. We strive very hard to maintain a stable API. Changes that\\n   require changes for projects using leveldb _might_ be rejected without\\n   sufficient benefit to the project.\\n\\n3. **Tests**: All changes must be accompanied by a new (or changed) test, or\\n   a sufficient explanation as to why a new (or changed) test is not required.\\n\\n4. **Consistent Style**: This project conforms to the\\n   [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html).\\n   To ensure your changes are properly formatted please run:\\n\\n   ```\\n   clang-format -i --style=file <file>\\n   ```\\n\\n## Submitting a Pull Request\\n\\nBefore any pull request will be accepted the author must first sign a\\nContributor License Agreement (CLA) at https://cla.developers.google.com/.\\n\\nIn order to keep the commit timeline linear\\n[squash](https://git-scm.com/book/en/v2/Git-Tools-Rewriting-History#Squashing-Commits)\\nyour changes down to a single commit and [rebase](https://git-scm.com/docs/git-rebase)\\non google/leveldb/master. This keeps the commit timeline linear and more easily sync'ed\\nwith the internal repository at Google. More information at GitHub's\\n[About Git rebase](https://help.github.com/articles/about-git-rebase/) page.\\n\\n# Performance\\n\\nHere is a performance report (with explanations) from the run of the\\nincluded db_bench program.  The results are somewhat noisy, but should\\nbe enough to get a ballpark performance estimate.\\n\\n## Setup\\n\\nWe use a database with a million entries.  Each entry has a 16 byte\\nkey, and a 100 byte value.  Values used by the benchmark compress to\\nabout half their original size.\\n\\n    LevelDB:    version 1.1\\n    Date:       Sun May  1 12:11:26 2011\\n    CPU:        4 x Intel(R) Core(TM)2 Quad CPU    Q6600  @ 2.40GHz\\n    CPUCache:   4096 KB\\n    Keys:       16 bytes each\\n    Values:     100 bytes each (50 bytes after compression)\\n    Entries:    1000000\\n    Raw Size:   110.6 MB (estimated)\\n    File Size:  62.9 MB (estimated)\\n\\n## Write performance\\n\\nThe \\\"fill\\\" benchmarks create a brand new database, in either\\nsequential, or random order.  The \\\"fillsync\\\" benchmark flushes data\\nfrom the operating system to the disk after every operation; the other\\nwrite operations leave the data sitting in the operating system buffer\\ncache for a while.  The \\\"overwrite\\\" benchmark does random writes that\\nupdate existing keys in the database.\\n\\n    fillseq      :       1.765 micros/op;   62.7 MB/s\\n    fillsync     :     268.409 micros/op;    0.4 MB/s (10000 ops)\\n    fillrandom   :       2.460 micros/op;   45.0 MB/s\\n    overwrite    :       2.380 micros/op;   46.5 MB/s\\n\\nEach \\\"op\\\" above corresponds to a write of a single key/value pair.\\nI.e., a random write benchmark goes at approximately 400,000 writes per second.\\n\\nEach \\\"fillsync\\\" operation costs much less (0.3 millisecond)\\nthan a disk seek (typically 10 milliseconds).  We suspect that this is\\nbecause the hard disk itself is buffering the update in its memory and\\nresponding before the data has been written to the platter.  This may\\nor may not be safe based on whether or not the hard disk has enough\\npower to save its memory in the event of a power failure.\\n\\n## Read performance\\n\\nWe list the performance of reading sequentially in both the forward\\nand reverse direction, and also the performance of a random lookup.\\nNote that the database created by the benchmark is quite small.\\nTherefore the report characterizes the performance of leveldb when the\\nworking set fits in memory.  The cost of reading a piece of data that\\nis not present in the operating system buffer cache will be dominated\\nby the one or two disk seeks needed to fetch the data from disk.\\nWrite performance will be mostly unaffected by whether or not the\\nworking set fits in memory.\\n\\n    readrandom  : 16.677 micros/op;  (approximately 60,000 reads per second)\\n    readseq     :  0.476 micros/op;  232.3 MB/s\\n    readreverse :  0.724 micros/op;  152.9 MB/s\\n\\nLevelDB compacts its underlying storage data in the background to\\nimprove read performance.  The results listed above were done\\nimmediately after a lot of random writes.  The results after\\ncompactions (which are usually triggered automatically) are better.\\n\\n    readrandom  : 11.602 micros/op;  (approximately 85,000 reads per second)\\n    readseq     :  0.423 micros/op;  261.8 MB/s\\n    readreverse :  0.663 micros/op;  166.9 MB/s\\n\\nSome of the high cost of reads comes from repeated decompression of blocks\\nread from disk.  If we supply enough cache to the leveldb so it can hold the\\nuncompressed blocks in memory, the read performance improves again:\\n\\n    readrandom  : 9.775 micros/op;  (approximately 100,000 reads per second before compaction)\\n    readrandom  : 5.215 micros/op;  (approximately 190,000 reads per second after compaction)\\n\\n## Repository contents\\n\\nSee [doc/index.md](doc/index.md) for more explanation. See\\n[doc/impl.md](doc/impl.md) for a brief overview of the implementation.\\n\\nThe public interface is in include/leveldb/*.h.  Callers should not include or\\nrely on the details of any other header files in this package.  Those\\ninternal APIs may be changed without warning.\\n\\nGuide to header files:\\n\\n* **include/leveldb/db.h**: Main interface to the DB: Start here.\\n\\n* **include/leveldb/options.h**: Control over the behavior of an entire database,\\nand also control over the behavior of individual reads and writes.\\n\\n* **include/leveldb/comparator.h**: Abstraction for user-specified comparison function.\\nIf you want just bytewise comparison of keys, you can use the default\\ncomparator, but clients can write their own comparator implementations if they\\nwant custom ordering (e.g. to handle different character encodings, etc.).\\n\\n* **include/leveldb/iterator.h**: Interface for iterating over data. You can get\\nan iterator from a DB object.\\n\\n* **include/leveldb/write_batch.h**: Interface for atomically applying multiple\\nupdates to a database.\\n\\n* **include/leveldb/slice.h**: A simple module for maintaining a pointer and a\\nlength into some other byte array.\\n\\n* **include/leveldb/status.h**: Status is returned from many of the public interfaces\\nand is used to report success and various kinds of errors.\\n\\n* **include/leveldb/env.h**:\\nAbstraction of the OS environment.  A posix implementation of this interface is\\nin util/env_posix.cc.\\n\\n* **include/leveldb/table.h, include/leveldb/table_builder.h**: Lower-level modules that most\\nclients probably won't use directly.\\n