# Contributing\\n\\nWe'd love to accept your code patches! However, before we can take them, we\\nhave to jump a couple of legal hurdles.\\n\\n## Contributor License Agreements\\n\\nPlease fill out either the individual or corporate Contributor License\\nAgreement as appropriate.\\n\\n* If you are an individual writing original source code and you're sure you\\nown the intellectual property, then sign an [individual CLA](https://developers.google.com/open-source/cla/individual).\\n* If you work for a company that wants to allow you to contribute your work,\\nthen sign a [corporate CLA](https://developers.google.com/open-source/cla/corporate).\\n\\nFollow either of the two links above to access the appropriate CLA and\\ninstructions for how to sign and return it.\\n\\n## Submitting a Patch\\n\\n1. Sign the contributors license agreement above.\\n2. Decide which code you want to submit. A submission should be a set of changes\\nthat addresses one issue in the [issue tracker](https://github.com/google/leveldb/issues).\\nPlease don't mix more than one logical change per submission, because it makes\\nthe history hard to follow. If you want to make a change\\n(e.g. add a sample or feature) that doesn't have a corresponding issue in the\\nissue tracker, please create one.\\n3. **Submitting**: When you are ready to submit, send us a Pull Request. Be\\nsure to include the issue number you fixed and the name you used to sign\\nthe CLA.\\n\\n## Writing Code ##\\n\\nIf your contribution contains code, please make sure that it follows\\n[the style guide](https://google.github.io/styleguide/cppguide.html).\\nOtherwise we will have to ask you to make changes, and that's no fun for anyone.\\n