## Contributing to the Guideline Support Library\\r\\n\\r\\nThe Guideline Support Library (GSL) contains functions and types that are suggested for use by the\\r\\n[C++ Core Guidelines](https://github.com/isocpp/CppCoreGuidelines). GSL design changes are made only as a result of modifications to the Guidelines. \\r\\n\\r\\nGSL is accepting contributions that improve or refine any of the types in this library as well as ports to other platforms. Changes should have an issue \\r\\ntracking the suggestion that has been approved by the maintainers. Your pull request should include a link to the bug that you are fixing. If you've submitted \\r\\na PR, please post a comment in the associated issue to avoid duplication of effort.\\r\\n\\r\\n## Legal\\r\\nYou will need to complete a Contributor License Agreement (CLA). Briefly, this agreement testifies that you are granting us and the community permission to \\r\\nuse the submitted change according to the terms of the project's license, and that the work being submitted is under appropriate copyright.\\r\\n\\r\\nPlease submit a Contributor License Agreement (CLA) before submitting a pull request. You may visit https://cla.microsoft.com to sign digitally.\\r\\n\\r\\n## Housekeeping\\r\\nYour pull request should: \\r\\n\\r\\n* Include a description of what your change intends to do\\r\\n* Be a child commit of a reasonably recent commit in the **master** branch \\r\\n    * Requests need not be a single commit, but should be a linear sequence of commits (i.e. no merge commits in your PR)\\r\\n* It is desirable, but not necessary, for the tests to pass at each commit. Please see [README.md](./README.md) for instructions to build the test suite. \\r\\n* Have clear commit messages \\r\\n    * e.g. \\\"Fix issue\\\", \\\"Add tests for type\\\", etc.\\r\\n* Include appropriate tests \\r\\n    * Tests should include reasonable permutations of the target fix/change\\r\\n    * Include baseline changes with your change\\r\\n    * All changed code must have 100% code coverage\\r\\n* To avoid line ending issues, set `autocrlf = input` and `whitespace = cr-at-eol` in your git configuration\\r\\n