/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.unittests;

import de.cadenas.catalogsearch.lucene.LuceneSearchService;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.analysis.filter.CompoundWordTokenFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.WordDelimiterGraphFilter;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class UnitTestMain {
    final String cadenasData;
    private static final PLogger logger = new PLogger(LuceneSearchService.class.getSimpleName());

    UnitTestMain(String cadenasData) {
        this.cadenasData = cadenasData;
    }

    boolean unitTest(String methodName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, IllegalAccessException {
        Method[] methods;
        Class<?> classObj = this.getClass();
        if (!methodName.isEmpty()) {
            Method method = classObj.getMethod(methodName, new Class[0]);
            return (Boolean)method.invoke((Object)this, new Object[0]);
        }
        for (Method method : methods = classObj.getMethods()) {
            boolean ret;
            if (!method.getName().startsWith("test") || (ret = ((Boolean)method.invoke((Object)this, new Object[0])).booleanValue())) continue;
            return false;
        }
        return true;
    }

    public boolean testAnalyzer() throws IOException {
        ArrayList<TestData> list = new ArrayList<TestData>();
        list.add(new TestData("Schraubenbausatz", "Schraubenbausatz Schraubenbausatz Schrauben schraub rauben raub bau satz", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("Inhalt des CAD-Kataloges in PARTsolutions", "Inhalt Inhalt des des CAD-Kataloges CAD-Katalog Kataloges katalog in in PARTsolutions PARTsolutio PART ART solutions solutio", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("SchraubeWelle", "SchraubeWelle SchraubeWell Schraube schraub raube raub Welle", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("SchraubeWellen", "SchraubeWellen SchraubeWell Schraube schraub raube raub Wellen welle ellen ell", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("SchraubeWellenDichtring", "SchraubeWellenDichtring SchraubeWellenDichtring Schraube schraub raube raub welle Wellen ellen ell Dicht ring", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("SchraubeWellenDichtinsel", "SchraubeWellenDichtinsel SchraubeWellenDichtinsel Schraube schraub raube raub welle Wellen ellen ell Dicht insel", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("Sechskantschraubenzwingen", "Sechskantschraubenzwingen Sechskantschraubenzwing Sechs kant schrauben schraub rauben raub zwingen zwing", "", UnitTestMain::analyzeCompoundWord));
        list.add(new TestData("Wellen-Dichtung", "Wellen Dichtung", "", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("text4text", "text 4 text", "", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("100.200-300?400*500", "100 200 300 400 500", "", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("What's up", "What s up", "", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("What's up", "What's up", "E", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("What's", "What's", "E", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("What'sx", "What sx", "E", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("What'b up", "What b up", "E", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("300?ex", "300? ex", "W", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("300?400", "300?400", "W", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("abc*def", "abc*def", "W", UnitTestMain::analyzeDelimeter));
        list.add(new TestData("Schraubenbausatz", "schraubenbausatz schrauben schraub rauben raub bau satz", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("ringradialwellendicht", "ringradialwellendicht ringradialwellendich ring radial rad welle wellen ellen ell dicht", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("\u00dcberwurfschrauben", "\u00fcberwurfschrauben uberwurfschraub \u00fcberwurf \u00fcber wurfs wurf schrauben schraub rauben raub", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("Krane, Laufr\u00e4der mit W\u00e4lzlagerung, Verschlussdeckel, Form B f\u00fcr Radial-Wellendichtringe", "krane kran laufr\u00e4der laufrad lauf r\u00e4der rad mit w\u00e4lzlagerung walzlagerung w\u00e4lz lager lagerung verschlussdeckel verschluss schluss decke deck deckel form b f\u00fcr fur radial rad wellendichtringe wellendichtring welle wellen ellen ell dicht ringe ring", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("DTDXN", "dtdxn dtdx", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("ABC-XZD-X4F", "abc xzd x 4 f", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("augustinerchorfrauenstifte", "augustinerchorfrauenstifte augustinerchorfrauenstif augustiner augustin august chor frauen frau rauen stifte stift", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("xxxxxschraube", "xxxxxschraube xxxxxschraub schraube schraub raube raub", "nb_german_lang", UnitTestMain::analyzeString));
        list.add(new TestData("What's up", "what's what up", "nb_english_lang", UnitTestMain::analyzeString));
        list.add(new TestData("j\u2019examine", "j\u2019examine examin", "nb_french_lang", UnitTestMain::analyzeString));
        list.add(new TestData("l\u2019hotel paris", "l\u2019hotel hotel paris pari", "nb_french_lang", UnitTestMain::analyzeString));
        list.add(new TestData("L\u2019Hotel", "l\u2019hotel hotel", "nb_french_lang", UnitTestMain::analyzeString));
        list.add(new TestData("A10 B20 C30", "a 10 b 20 c 30", "document_french_lang", UnitTestMain::analyzeString));
        ArrayList resultList = new ArrayList();
        for (TestData item : list) {
            StringBuilder builder = new StringBuilder();
            List<AnalyzeResult> lst = item.iface.analyze(item.queryText, item.flags);
            for (AnalyzeResult litem : lst) {
                builder.append(litem.tokenString);
                builder.append(" ");
            }
            String result = builder.toString();
            boolean ret = this.compare(item.iface.analyze(item.queryText, item.flags), this.createAnalyzeResult4Compare(item.compareText));
            if (ret) continue;
            return false;
        }
        return true;
    }

    private static List<AnalyzeResult> analyzeString(String queryText, String fieldName) throws IOException {
        ArrayList<AnalyzeResult> result = new ArrayList();
        FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(true);
        StringReader reader = new StringReader(queryText);
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, (Reader)reader);){
            result = UnitTestMain.createAnalyzeResult(tokenStream);
        }
        return result;
    }

    private static List<AnalyzeResult> analyzeDelimeter(String queryText, String flags) throws IOException {
        WhitespaceTokenizer src;
        StringReader reader = new StringReader(queryText);
        WhitespaceTokenizer stream = src = new WhitespaceTokenizer();
        boolean keepEnglishPossesive = flags.contains("E");
        boolean keepWildcard = flags.contains("W");
        stream = new WordDelimiterGraphFilter((TokenStream)stream, keepEnglishPossesive, keepWildcard);
        Analyzer.TokenStreamComponents components = new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)stream);
        components.getSource().accept(reader);
        return UnitTestMain.createAnalyzeResult((TokenStream)stream);
    }

    private static List<AnalyzeResult> analyzeCompoundWord(String queryText, String flags) throws IOException {
        StringReader reader = new StringReader(queryText);
        WhitespaceTokenizer src = new WhitespaceTokenizer();
        CharArrayMap dictionary = FieldAwareAnalyzer.getStemmedDict((String)"german");
        CompoundWordTokenFilter compound = new CompoundWordTokenFilter((TokenStream)src, dictionary, null, true, false);
        Analyzer.TokenStreamComponents components = new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)compound);
        components.getSource().accept(reader);
        return UnitTestMain.createAnalyzeResult((TokenStream)compound);
    }

    private static List<AnalyzeResult> createAnalyzeResult(TokenStream tokenStream) throws IOException {
        ArrayList<AnalyzeResult> result = new ArrayList<AnalyzeResult>();
        CharTermAttribute termAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncAttr = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            AnalyzeResult oneResult = new AnalyzeResult();
            oneResult.tokenString = termAttribute.toString();
            oneResult.increment = posIncAttr.getPositionIncrement();
            oneResult.offset = offsetAtt.startOffset();
            oneResult.endOffset = offsetAtt.endOffset();
            result.add(oneResult);
        }
        return result;
    }

    private List<AnalyzeResult> createAnalyzeResult4Compare(String text) {
        ArrayList<AnalyzeResult> result = new ArrayList<AnalyzeResult>();
        String[] parts = text.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            AnalyzeResult oneResult = new AnalyzeResult();
            oneResult.tokenString = parts[i];
            result.add(oneResult);
        }
        return result;
    }

    private boolean compare(List<AnalyzeResult> list1, List<AnalyzeResult> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get((int)i).tokenString.equals(list2.get((int)i).tokenString)) continue;
            return false;
        }
        return true;
    }

    class TestData {
        String queryText;
        String compareText;
        String flags;
        AnalyzeInterface iface;

        TestData(String queryText, String compareText, String flags, AnalyzeInterface iface) {
            this.queryText = queryText;
            this.compareText = compareText;
            this.flags = flags;
            this.iface = iface;
        }
    }

    static interface AnalyzeInterface {
        public List<AnalyzeResult> analyze(String var1, String var2) throws IOException;
    }

    static class AnalyzeResult {
        String tokenString;
        int increment;
        int offset;
        int endOffset;

        AnalyzeResult() {
        }
    }
}

