/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.IntTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public class FastTaxonomyFacetCounts
extends IntTaxonomyFacets {
    public FastTaxonomyFacetCounts(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        this("$facets", taxoReader, config, fc);
    }

    public FastTaxonomyFacetCounts(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config, fc);
        this.count(fc.getMatchingDocs());
    }

    public FastTaxonomyFacetCounts(String indexFieldName, IndexReader reader, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config, null);
        this.countAll(reader);
    }

    private final void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            SortedNumericDocValues dv = FacetUtils.loadOrdinalValues(hits.context.reader(), this.indexFieldName);
            if (dv == null) continue;
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                for (int i = 0; i < dv.docValueCount(); ++i) {
                    this.increment((int)dv.nextValue());
                }
                doc = it.nextDoc();
            }
        }
        this.rollup();
    }

    private final void countAll(IndexReader reader) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            SortedNumericDocValues dv = FacetUtils.loadOrdinalValues(context.reader(), this.indexFieldName);
            if (dv == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            int doc = dv.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    for (int i = 0; i < dv.docValueCount(); ++i) {
                        this.increment((int)dv.nextValue());
                    }
                }
                doc = dv.nextDoc();
            }
        }
        this.rollup();
    }
}

