/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.util;

import java.util.List;
import java.util.stream.Collectors;

public class PLogger {
    public static int TRACE = 5000;
    public static int DEBUG = 10000;
    public static int INFO = 20000;
    public static int WARNING = 30000;
    public static int ERROR;
    private static final int logLevel;
    private final String className;

    private static String getMethodName(int depth) {
        List stack = StackWalker.getInstance().walk(s -> s.limit(depth).collect(Collectors.toList()));
        if (stack != null && stack.size() >= depth) {
            return ((StackWalker.StackFrame)stack.get(depth - 1)).getMethodName();
        }
        return "";
    }

    private static native void logMessage(int var0, String var1, String var2, String var3);

    private void logInternal(int level, String message) {
        if (level >= logLevel) {
            String method = PLogger.getMethodName(4);
            PLogger.logMessage(level, this.className, method, message);
        }
    }

    public PLogger(String className) {
        this.className = className;
    }

    public void log(int level, String message) {
        if (level >= logLevel) {
            String method = PLogger.getMethodName(2);
            PLogger.logMessage(level, this.className, method, message);
        }
    }

    public void trace(String message) {
        this.logInternal(TRACE, message);
    }

    public void debug(String message) {
        this.logInternal(DEBUG, message);
    }

    public void info(String message) {
        this.logInternal(INFO, message);
    }

    public void warn(String message) {
        this.logInternal(WARNING, message);
    }

    public void error(Throwable e) {
        StackTraceElement[] traceElements = e.getStackTrace();
        if (traceElements != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.toString());
            for (StackTraceElement el : traceElements) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(el.toString());
            }
            this.logInternal(ERROR, sb.toString());
        }
    }

    public void error(String message) {
        this.logInternal(ERROR, message);
    }

    public boolean traceEnabled() {
        return TRACE >= logLevel;
    }

    public boolean debugEnabled() {
        return DEBUG >= logLevel;
    }

    public boolean infoEnabled() {
        return INFO >= logLevel;
    }

    public boolean warningEnabled() {
        return WARNING >= logLevel;
    }

    public boolean errorEnabled() {
        return ERROR >= logLevel;
    }

    static {
        logLevel = ERROR = 40000;
    }
}

