/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.util;

import de.cadenas.util.PGenericPair;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BytesRef;

public class PDataStream {
    private LeOutputStream outStream = null;
    private ByteBuffer byteBuffer = null;

    public PDataStream(BytesRef br) {
        this(br.bytes, br.offset, br.length);
    }

    public PDataStream(byte[] data, int offset, int length) {
        this.byteBuffer = ByteBuffer.wrap(data, offset, length);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public PDataStream(OutputStream outStream) {
        this.outStream = new LeOutputStream(outStream);
    }

    public boolean atEnd() {
        if (this.byteBuffer == null) {
            return false;
        }
        return this.byteBuffer.position() >= this.byteBuffer.limit();
    }

    public int readInt() {
        return this.byteBuffer.getInt();
    }

    public int readVInt() {
        byte b = this.byteBuffer.get();
        if (b >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = this.byteBuffer.get();
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.byteBuffer.get();
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.byteBuffer.get();
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.byteBuffer.get();
        i |= (b & 0xF) << 28;
        if ((b & 0xF0) == 0) {
            return i;
        }
        return 0;
    }

    public boolean readBool() {
        byte bt = this.byteBuffer.get();
        return bt != 0;
    }

    public byte readByte() {
        return this.byteBuffer.get();
    }

    public double readDouble() {
        return this.byteBuffer.getDouble();
    }

    public String readString() {
        int size = this.byteBuffer.getInt();
        if (size == -1) {
            return null;
        }
        byte[] buf = new byte[size];
        this.byteBuffer.get(buf);
        return new String(buf, StandardCharsets.UTF_16LE);
    }

    public String readVString() {
        int size = this.readVInt();
        if (size == 0 || size == -1) {
            return null;
        }
        byte[] buf = new byte[size];
        this.byteBuffer.get(buf);
        return new String(buf, StandardCharsets.UTF_16LE);
    }

    public byte[] readBytes() {
        int size = this.readVInt();
        if (size == 0) {
            return null;
        }
        byte[] buf = new byte[size];
        this.byteBuffer.get(buf);
        return buf;
    }

    public void readBytes(BytesRef br) {
        int size = this.readVInt();
        br.bytes = this.byteBuffer.array();
        br.offset = this.byteBuffer.position();
        br.length = size;
        this.byteBuffer.position(this.byteBuffer.position() + size);
    }

    public Map<String, String> readStringMap() {
        HashMap<String, String> ret = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            ret = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = this.readString();
                String value = this.readString();
                ret.put(key, value);
            }
        }
        return ret;
    }

    public Set<String> readStringSet() {
        HashSet<String> ret = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            ret = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                String value = this.readString();
                ret.add(value);
            }
        }
        return ret;
    }

    public List<PGenericPair<String, String>> readStringPairList() {
        ArrayList<PGenericPair<String, String>> ret = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            ret = new ArrayList<PGenericPair<String, String>>(size);
            for (int i = 0; i < size; ++i) {
                String key = this.readString();
                String value = this.readString();
                ret.add(new PGenericPair<String, String>(key, value));
            }
        }
        return ret;
    }

    public List<String> readStringList() {
        ArrayList<String> list = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String value = this.readString();
                list.add(value);
            }
        }
        return list;
    }

    public List<Double> readDoubleList() {
        ArrayList<Double> ret = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            ret = new ArrayList<Double>(size);
            for (int i = 0; i < size; ++i) {
                double d = this.byteBuffer.getDouble();
                ret.add(d);
            }
        }
        return ret;
    }

    public List<Boolean> readBoolList() {
        ArrayList<Boolean> ret = null;
        int size = this.byteBuffer.getInt();
        if (size > 0) {
            ret = new ArrayList<Boolean>(size);
            for (int i = 0; i < size; ++i) {
                Boolean d = this.readBool();
                ret.add(d);
            }
        }
        return ret;
    }

    public void write(int i) throws IOException {
        this.outStream.writeInt(i);
    }

    public void writeVInt(int i) throws IOException {
        this.outStream.writeVInt(i);
    }

    public void write(boolean b) throws IOException {
        this.outStream.writeBoolean(b);
    }

    public void write(double d) throws IOException {
        this.outStream.writeDouble(d);
    }

    public void write(long l) throws IOException {
        this.outStream.writeLong(l);
    }

    public void write(String s) throws IOException {
        if (s == null) {
            this.outStream.writeInt(-1);
        } else {
            byte[] data = s.getBytes(StandardCharsets.UTF_16LE);
            this.outStream.writeInt(data.length);
            this.outStream.write(data);
        }
    }

    public void writeVString(String s) throws IOException {
        if (s == null || s.isEmpty()) {
            this.outStream.writeVInt(0);
        } else {
            byte[] data = s.getBytes(StandardCharsets.UTF_16LE);
            this.outStream.writeVInt(data.length);
            this.outStream.write(data);
        }
    }

    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.outStream.writeVInt(b.length);
            this.outStream.write(b, 0, b.length);
        } else {
            this.outStream.writeVInt(0);
        }
    }

    public void write(BytesRef b) throws IOException {
        this.outStream.writeVInt(b.length);
        this.outStream.write(b.bytes, b.offset, b.length);
    }

    private static class LeOutputStream {
        private final OutputStream out;
        private final byte[] buffer;

        public LeOutputStream(OutputStream stream) {
            this.out = stream;
            this.buffer = new byte[8];
        }

        public void writeInt(int v) throws IOException {
            this.buffer[0] = (byte)(v & 0xFF);
            this.buffer[1] = (byte)(v >>> 8 & 0xFF);
            this.buffer[2] = (byte)(v >>> 16 & 0xFF);
            this.buffer[3] = (byte)(v >>> 24 & 0xFF);
            this.out.write(this.buffer, 0, 4);
        }

        public void writeVInt(int i) throws IOException {
            int index = 0;
            while ((i & 0xFFFFFF80) != 0) {
                this.buffer[index++] = (byte)(i & 0x7F | 0x80);
                i >>>= 7;
            }
            this.buffer[index] = (byte)i;
            this.out.write(this.buffer, 0, index + 1);
        }

        public void writeLong(long v) throws IOException {
            this.buffer[0] = (byte)v;
            this.buffer[1] = (byte)(v >>> 8);
            this.buffer[2] = (byte)(v >>> 16);
            this.buffer[3] = (byte)(v >>> 24);
            this.buffer[4] = (byte)(v >>> 32);
            this.buffer[5] = (byte)(v >>> 40);
            this.buffer[6] = (byte)(v >>> 48);
            this.buffer[7] = (byte)(v >>> 56);
            this.out.write(this.buffer);
        }

        public void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        public void writeBoolean(boolean v) throws IOException {
            this.out.write(v ? 1 : 0);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
        }
    }
}

