/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.util;

import de.cadenas.util.PConfig;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NumUtils {
    private static final Map<String, Double> unitFactors = new HashMap<String, Double>();
    private static final Object2IntMap<String> unitPhysicalQuantities = new Object2IntOpenHashMap<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double convertToBaseUnit(double value, String targetUnit) {
        double factor = 1.0;
        Map<String, Double> map = unitFactors;
        synchronized (map) {
            if (unitFactors.isEmpty()) {
                try (PConfig unitsCfg = new PConfig("$CADENAS_SETUP/baseunits.cfg");){
                    String[] blocks = unitsCfg.getBlocks();
                    if (blocks != null && blocks.length > 0) {
                        for (String block : blocks) {
                            if (block.toLowerCase().startsWith("mapping_")) continue;
                            int blockPq = unitsCfg.getInt("_index", block);
                            String[] units = unitsCfg.getKeys(block);
                            if (units == null) continue;
                            for (String unit : units) {
                                String strFactor;
                                double uFactor;
                                if (unit.startsWith("_") || Double.isNaN(uFactor = NumUtils.getNumeric(strFactor = unitsCfg.getValue(unit, block)))) continue;
                                String lcUnit = unit.toLowerCase();
                                unitFactors.put(lcUnit, uFactor);
                                unitPhysicalQuantities.put(lcUnit, blockPq);
                            }
                        }
                    }
                }
            }
            factor = unitFactors.getOrDefault(targetUnit.toLowerCase(), 1.0);
        }
        return value * factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUnitPhysicalQuantity(String unit) {
        Map<String, Double> map = unitFactors;
        synchronized (map) {
            return unitPhysicalQuantities.getInt(unit.toLowerCase(Locale.ROOT));
        }
    }

    public static double getNumeric(String value) {
        if (value == null || value.isEmpty()) {
            return Double.NaN;
        }
        char c = value.charAt(value.length() - 1);
        if (c == 'd' || c == 'D' || c == 'f' || c == 'F') {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static double combine(double d, int flags, int pq) {
        return NumUtils.combine((float)d, flags, pq);
    }

    public static double combine(float f, int flags, int pq) {
        int fBits = Float.floatToIntBits(f);
        long l = (long)fBits << 32;
        pq <<= 8;
        return Double.longBitsToDouble(l |= (long)(pq |= flags));
    }

    public static int getInteger(String value) {
        try {
            int d = Integer.parseInt(value);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    public static double parseInch(String inch) {
        int index = inch.indexOf(32, 1);
        if (index == -1) {
            index = inch.indexOf(45, 1);
        }
        if (index == -1) {
            return NumUtils.inchFragmentToDouble(inch);
        }
        String substr = inch.substring(0, index);
        try {
            int base = Integer.parseInt(substr);
            substr = inch.substring(index + 1);
            double fraction = NumUtils.inchFragmentToDouble(substr);
            if (Double.isNaN(fraction)) {
                return fraction;
            }
            return (double)base + fraction;
        }
        catch (NumberFormatException ignored) {
            return Double.NaN;
        }
    }

    public static double inchFragmentToDouble(String fragment) {
        int index = fragment.indexOf(47, 1);
        if (index != -1 && fragment.indexOf(47, index + 1) == -1) {
            String substr = fragment.substring(0, index);
            try {
                int numerator = Integer.parseInt(substr);
                substr = fragment.substring(index + 1);
                int denominator = Integer.parseInt(substr);
                if (denominator != 0) {
                    return (double)numerator / (double)denominator;
                }
            }
            catch (NumberFormatException ignored) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }
}

