/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.util;

import de.cadenas.catalogsearch.api.IIndexLoadRequest;
import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.api.ISearchResult;
import de.cadenas.catalogsearch.api.ISearchResultError;
import de.cadenas.catalogsearch.api.ISearchResultFilter;
import de.cadenas.catalogsearch.api.ISearchResultFilterValue;
import de.cadenas.catalogsearch.api.ISearchResultItem;
import de.cadenas.catalogsearch.api.impl.IndexLoadRequestImpl;
import de.cadenas.catalogsearch.api.impl.SearchRequestImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.index.MergeIndexData;
import de.cadenas.catalogsearch.lucene.index.ProjectInfoData;
import de.cadenas.catalogsearch.lucene.index.RemoveDataRequest;
import de.cadenas.catalogsearch.lucene.search.SearchResultFilter;
import de.cadenas.util.PGenericPair;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonSerialization {
    public static JSONObject toJson(ISearchResult result, long startTime) {
        JSONObject jResult = new JSONObject();
        jResult.put("totalHitCount", result.getTotalHitCount());
        jResult.put("totalProjectCount", result.getProjectCount());
        String commonDir = result.getCommonDirectory();
        if (commonDir != null && !commonDir.isEmpty()) {
            jResult.put("commonDirectory", commonDir);
        }
        JSONArray jItems = new JSONArray();
        for (ISearchResultItem iSearchResultItem : result.getItems()) {
            if (iSearchResultItem == null) continue;
            jItems.put(JsonSerialization.toJson(iSearchResultItem));
        }
        jResult.put("items", jItems);
        JSONArray jFilters = new JSONArray();
        for (ISearchResultFilter filter : result.getFilters()) {
            if (filter == null) continue;
            jFilters.put(JsonSerialization.toJson(filter));
        }
        jResult.put("filters", jFilters);
        if (result.getChildFolderFilter() != null) {
            JSONArray jSONArray = new JSONArray();
            for (String filter : result.getChildFolderFilter()) {
                jSONArray.put(filter);
            }
            jResult.put("childFolderFilter", jSONArray);
        }
        if (result.getErrors() != null) {
            JSONArray jSONArray = new JSONArray();
            for (ISearchResultError err : result.getErrors()) {
                jSONArray.put(JsonSerialization.toJson(err));
            }
            jResult.put("errors", jSONArray);
        }
        jResult.put("searchId", result.getSearchId());
        long l = System.nanoTime() - startTime;
        jResult.put("execTime", l);
        jResult.put("moreVarFacetsAvailable", result.getMoreVarFacetsAvailable());
        return jResult;
    }

    private static JSONObject toJson(ISearchResultItem item) {
        List<ISearchResultItem.DocumentInfo> docInfos;
        JSONObject jItem = new JSONObject();
        jItem.put("score", item.getScore());
        jItem.put("catalog", item.getCatalog());
        jItem.put("path", item.getPath());
        jItem.put("lineId", item.getLineId());
        jItem.put("lineSubId", item.getLineSubId());
        if (item.getVarset() != null && !item.getVarset().isEmpty()) {
            jItem.put("varset", item.getVarset());
        }
        if (!item.hidesOriginalLine()) {
            jItem.put("hidesOriginalLine", true);
        }
        if (item.getExplanation() != null && !item.getExplanation().isEmpty()) {
            jItem.put("explanation", item.getExplanation());
        }
        if ((docInfos = item.getDocumentInfos()) != null) {
            JSONArray jDocList = new JSONArray();
            for (ISearchResultItem.DocumentInfo docInfo : docInfos) {
                JSONObject jDocInfo = new JSONObject();
                jDocInfo.put("column", docInfo.columnName);
                jDocInfo.put("path", docInfo.documentPath);
                jDocInfo.put("basePath", docInfo.basePath);
                jDocInfo.put("relPath", docInfo.documentRelPath);
                if (docInfo.fragments != null) {
                    JSONArray jFrags = new JSONArray();
                    for (String fragment : docInfo.fragments) {
                        jFrags.put(fragment);
                    }
                    jDocInfo.put("fragments", jFrags);
                }
                jDocList.put(jDocInfo);
            }
            jItem.put("documents", jDocList);
        }
        return jItem;
    }

    private static JSONObject toJson(ISearchResultError error) {
        String[] args;
        JSONObject jError = new JSONObject();
        jError.put("id", error.getID());
        jError.put("no", error.getNo());
        JSONArray jArguments = new JSONArray();
        for (String arg : args = error.getArguments()) {
            jArguments.put(arg);
        }
        jError.put("arguments", jArguments);
        if (error.getData() != null) {
            String[] datas;
            JSONArray jData = new JSONArray();
            for (String data : datas = error.getData()) {
                jData.put(data);
            }
            jError.put("data", jData);
        }
        return jError;
    }

    private static JSONObject toJson(ISearchResultFilter filter) {
        JSONObject jFilter = new JSONObject();
        jFilter.put("name", filter.getName());
        jFilter.put("matchCount", filter.getMatchCount());
        if (filter.isRangeFilter()) {
            jFilter.put("rangeFilter", true);
        }
        if (filter.useValueList() && !filter.useMinMax()) {
            jFilter.put("valueList", true);
        }
        if (filter.isErp()) {
            jFilter.put("erp", true);
        }
        JSONArray jFilterValues = new JSONArray();
        List<ISearchResultFilterValue> values = filter.getValues();
        for (ISearchResultFilterValue value : values) {
            jFilterValues.put(JsonSerialization.toJson(value));
        }
        jFilter.put("values", jFilterValues);
        return jFilter;
    }

    private static JSONObject toJson(ISearchResultFilterValue value) {
        JSONObject jValue = new JSONObject();
        jValue.put("value", value.getValue());
        jValue.put("matchCount", value.getMatchCount());
        return jValue;
    }

    public static JSONArray highlightingResponseToJson(PGenericPair<List<String>, Boolean> response) {
        JSONArray arr = new JSONArray();
        for (String frag : (List)response.first) {
            arr.put(frag);
        }
        arr.put(Boolean.TRUE.equals(response.second) ? "true" : "false");
        return arr;
    }

    public static JSONArray stringArrayToJson(String[] stringList) {
        JSONArray arr = new JSONArray();
        for (String item : stringList) {
            arr.put(item);
        }
        return arr;
    }

    public static ISearchRequest fromJson(JSONObject json) throws JSONException {
        JSONObject jFilter;
        int i;
        SearchRequestImpl req = new SearchRequestImpl();
        req.query = json.getString("query");
        req.offset = json.optInt("offset", req.offset);
        req.lineOffset = json.optInt("lineOffset");
        req.limit = json.optInt("limit", req.limit);
        req.variableFacetCount = json.optInt("variableFacetCount", req.variableFacetCount);
        req.facetedSearch = json.optBoolean("facets");
        req.facetTypes = json.optInt("facetTypes", 3);
        JSONArray jFacetFilter = json.optJSONArray("facetFilter");
        if (jFacetFilter != null && jFacetFilter.length() > 0) {
            req.facetFilter = new ArrayList<String>();
            for (int i2 = 0; i2 < jFacetFilter.length(); ++i2) {
                req.facetFilter.add(jFacetFilter.getString(i2));
            }
        }
        req.restoreVarsets = json.optBoolean("restoreVarsets", true);
        req.searchDocuments = json.optBoolean("searchDocuments", true);
        req.docHlStart = json.optString("docHlStart", "");
        req.docHlEnd = json.optString("docHlEnd", "");
        req.binaryResponse = json.optBoolean("binaryResponse", false);
        req.explainResults = json.optBoolean("explainResults", false);
        req.taxoSearch = json.optBoolean("taxo");
        req.treeView = json.optBoolean("treeView");
        if (req.treeView) {
            req.countProjects = json.optBoolean("countProjects");
        }
        req.evaluateCommonDir = json.optBoolean("evaluateCommonDir", true);
        req.keepSearch = json.optBoolean("keepSearch");
        req.searchId = json.optInt("searchId", -1);
        req.forceFacetCreation = json.optBoolean("forceFacetCreation");
        req.threadCount = json.optInt("threadCount", 0);
        req.erpFilterQuery = json.optString("erpFilterQuery");
        req.childFolderFilter = json.optString("childFolderFilter", null);
        if (json.has("languages")) {
            JSONArray arr = json.getJSONArray("languages");
            for (i = 0; i < arr.length(); ++i) {
                String lang = arr.getString(i);
                if (req.languageList.contains(lang)) continue;
                req.languageList.add(lang);
            }
        }
        if (json.has("pathFilters")) {
            JSONArray arr = json.getJSONArray("pathFilters");
            for (i = 0; i < arr.length(); ++i) {
                JSONObject jPathFilter = arr.getJSONObject(i);
                JSONArray jCatalogList = jPathFilter.optJSONArray("catalogList");
                JSONArray jTreeList = jPathFilter.optJSONArray("treeList");
                JSONArray jPathList = jPathFilter.optJSONArray("pathList");
                JSONArray jExcludeList = jPathFilter.optJSONArray("excludeList");
                req.pathFilters.add(new ISearchRequest.PathFilter(JsonSerialization.toStringList(jCatalogList), JsonSerialization.toStringList(jTreeList), JsonSerialization.toStringPairList(jPathList, "c", "p"), JsonSerialization.toStringList(jExcludeList)));
            }
        }
        if (json.has("excludedProjects")) {
            req.excludedProjects = new HashMap<String, List<String>>();
            JSONObject catMap = json.getJSONObject("excludedProjects");
            for (String catalog : catMap.keySet()) {
                ArrayList<String> pathList = new ArrayList<String>();
                JSONArray arr = catMap.getJSONArray(catalog);
                for (int i3 = 0; i3 < arr.length(); ++i3) {
                    pathList.add(arr.getString(i3));
                }
                req.excludedProjects.put(catalog, pathList);
            }
        }
        if (json.has("termFilters")) {
            JSONArray arr = json.getJSONArray("termFilters");
            for (int i4 = 0; i4 < arr.length(); ++i4) {
                jFilter = arr.getJSONObject(i4);
                req.termFilters.add(new ISearchRequest.TermFilter(jFilter.getString("field"), jFilter.getString("value"), jFilter.optBoolean("erp"), jFilter.optBoolean("and")));
            }
        }
        if (json.has("rangeFilters")) {
            JSONArray arr = json.getJSONArray("rangeFilters");
            for (int i5 = 0; i5 < arr.length(); ++i5) {
                jFilter = arr.getJSONObject(i5);
                req.rangeFilters.add(new ISearchRequest.RangeFilter(jFilter.getString("field"), jFilter.optDouble("low", Double.NaN), jFilter.optDouble("high", Double.NaN), jFilter.optBoolean("erp")));
            }
        }
        if (json.has("erpGroupName")) {
            req.erpGroupName = json.getString("erpGroupName");
            req.erpPreferredLine = json.optBoolean("erpPreferredLine", req.erpPreferredLine);
        }
        if (json.has("byProjectFilter")) {
            req.byProjectFilter = new SearchResultFilter();
            req.byProjectFilter.fromJson(json.getJSONObject("byProjectFilter"));
        }
        if (json.has("licenseRange")) {
            req.licenseRange = new ArrayList<ISearchRequest.LicenseRange>();
            JSONArray jLicRange = json.getJSONArray("licenseRange");
            for (int i6 = 0; i6 < jLicRange.length(); ++i6) {
                JSONObject jLicItem = jLicRange.getJSONObject(i6);
                req.licenseRange.add(new ISearchRequest.LicenseRange(jLicItem.optString("catalog"), jLicItem.optInt("low"), jLicItem.optInt("up")));
            }
        }
        return req;
    }

    private static List<String> toStringList(JSONArray jArray) {
        if (jArray != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < jArray.length(); ++i) {
                result.add(jArray.getString(i));
            }
            return result;
        }
        return null;
    }

    private static List<PGenericPair<String, String>> toStringPairList(JSONArray jArray, String key1, String key2) {
        if (jArray != null) {
            ArrayList<PGenericPair<String, String>> ret = new ArrayList<PGenericPair<String, String>>();
            for (int i = 0; i < jArray.length(); ++i) {
                JSONObject jobj = jArray.getJSONObject(i);
                String first = jobj.getString(key1);
                String second = jobj.getString(key2);
                ret.add(new PGenericPair<String, String>(first, second));
            }
            return ret;
        }
        return null;
    }

    public static List<IIndexLoadRequest> indexLoadRequestFromJson(JSONObject json) throws JSONException {
        JSONArray jLinkDb;
        ArrayList<IIndexLoadRequest> result = new ArrayList<IIndexLoadRequest>();
        JSONArray jFullText = json.optJSONArray("fulltext");
        if (jFullText != null) {
            for (int i = 0; i < jFullText.length(); ++i) {
                JSONObject jItem = jFullText.getJSONObject(i);
                result.add(JsonSerialization.indexLoadRequestFromJson(FieldDefinitions.IndexType.Fulltext, jItem));
            }
        }
        if ((jLinkDb = json.optJSONArray("linkdb")) != null) {
            for (int i = 0; i < jLinkDb.length(); ++i) {
                JSONObject jItem = jLinkDb.getJSONObject(i);
                result.add(JsonSerialization.indexLoadRequestFromJson(FieldDefinitions.IndexType.LinkDb, jItem));
            }
        }
        return result;
    }

    private static IIndexLoadRequest indexLoadRequestFromJson(FieldDefinitions.IndexType type, JSONObject jItem) throws JSONException {
        String catalogName = jItem.getString("catalogName");
        String indexPath = jItem.getString("indexPath");
        boolean preload = jItem.getBoolean("preload");
        boolean onlySearchIndex = jItem.getBoolean("onlySearchIndex");
        float boost = jItem.getFloat("boost");
        return new IndexLoadRequestImpl(type, catalogName, indexPath, preload, onlySearchIndex, boost);
    }

    public static RemoveDataRequest removeDataRequestFromJson(JSONArray json) throws JSONException {
        RemoveDataRequest request = new RemoveDataRequest();
        for (int i = 0; i < json.length(); ++i) {
            String path;
            JSONObject obj = json.getJSONObject(i);
            if (obj == null || (path = obj.optString("path")) == null || path.isEmpty()) continue;
            RemoveDataRequest.Item item = new RemoveDataRequest.Item();
            item.catalog = obj.optString("catalog");
            item.path = path;
            JSONArray jLineIds = obj.optJSONArray("lineIds");
            if (jLineIds != null) {
                item.lineIds = new ArrayList<Integer>();
                for (int l = 0; l < jLineIds.length(); ++l) {
                    int lineId = jLineIds.getInt(l);
                    item.lineIds.add(lineId);
                }
            }
            request.itemsToRemove.add(item);
        }
        return request;
    }

    public static MergeIndexData mergeRequestFromJson(JSONObject json) throws JSONException {
        MergeIndexData request = new MergeIndexData();
        request.indexPath = json.optString("indexPath");
        return request;
    }

    public static JSONArray toJson(List<ProjectInfoData> projectInfos) {
        JSONArray jProjects = new JSONArray();
        for (ProjectInfoData projectInfo : projectInfos) {
            JSONObject jProject = new JSONObject();
            jProject.put("path", projectInfo.path);
            if (projectInfo.lines != null && !projectInfo.lines.isEmpty()) {
                JSONArray jLines = new JSONArray();
                for (ProjectInfoData.Line line : projectInfo.lines) {
                    JSONObject jLine = new JSONObject();
                    jLine.put("docId", line.docId);
                    jLine.put("lineId", line.lineId);
                    jLine.put("lineSubId", line.lineSubId);
                    if (line.varset != null && !line.varset.isEmpty()) {
                        jLine.put("varset", line.varset);
                    }
                    jLines.put(jLine);
                }
                jProject.put("lines", jLines);
                if (projectInfo.documents != null) {
                    JSONArray jDocInfos = new JSONArray();
                    for (ProjectInfoData.DocInfo doc : projectInfo.documents) {
                        JSONObject jDoc = new JSONObject();
                        jDoc.put("docId", doc.docId);
                        jDoc.put("column", doc.column);
                        jDoc.put("content", doc.content);
                        if (doc.lineIds != null) {
                            JSONArray jLineIds = new JSONArray();
                            IntListIterator intListIterator = doc.lineIds.iterator();
                            while (intListIterator.hasNext()) {
                                int lineId = (Integer)intListIterator.next();
                                jLineIds.put(lineId);
                            }
                            jDoc.put("lineIds", jLineIds);
                        }
                        jDocInfos.put(jDoc);
                    }
                    jProject.put("docInfos", jDocInfos);
                }
            }
            jProjects.put(jProject);
        }
        return jProjects;
    }
}

