/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.util;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.index.FieldInfoData;
import de.cadenas.catalogsearch.lucene.index.ProjectInfoData;
import de.cadenas.util.Containers;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class IndexAnalyzer {
    private static final PLogger logger = new PLogger(IndexAnalyzer.class.getSimpleName());
    private final IndexReader reader;

    public IndexAnalyzer(IndexReader reader) {
        this.reader = reader;
    }

    private String bytesRefToString(BytesRef ref) {
        try {
            return ref.utf8ToString();
        }
        catch (Exception e) {
            return ref.toString();
        }
    }

    private void processTextualColumn(FieldInfoData.Item item, Terms terms, int[] docFilter) throws IOException {
        item.terms = new ArrayList<FieldInfoData.Term>();
        TermsEnum it = terms.iterator();
        BytesRef br = it.next();
        while (br != null) {
            FieldInfoData.Term ti = null;
            PostingsEnum pi = it.postings(null, 24);
            int currentDoc = -1;
            for (int nextDoc : docFilter) {
                if (nextDoc < currentDoc) continue;
                try {
                    if (currentDoc != nextDoc) {
                        currentDoc = pi.advance(nextDoc);
                    }
                    if (currentDoc == Integer.MAX_VALUE) break;
                    if (currentDoc > nextDoc) {
                    }
                }
                catch (Exception ignored) {}
                continue;
                if (ti == null) {
                    ti = new FieldInfoData.Term();
                    ti.documents = new ArrayList<FieldInfoData.Doc>();
                    ti.term = this.bytesRefToString(br);
                }
                FieldInfoData.Doc doc = new FieldInfoData.Doc();
                doc.id = nextDoc;
                doc.freq = pi.freq();
                if (doc.freq > 0) {
                    doc.positions = new Containers.IntList();
                    doc.positions.ensureCapacity(doc.freq);
                    doc.payloads = new Containers.IntList();
                    doc.payloads.ensureCapacity(doc.freq);
                    for (int f = 0; f < doc.freq; ++f) {
                        int pos = pi.nextPosition();
                        doc.positions.add(pos);
                        int docPayload = 0;
                        BytesRef payload = pi.getPayload();
                        if (payload != null && payload.length == 1) {
                            docPayload = payload.bytes[payload.offset];
                        }
                        doc.payloads.add(docPayload);
                    }
                }
                ti.documents.add(doc);
            }
            if (ti != null) {
                item.terms.add(ti);
            }
            br = it.next();
        }
    }

    private boolean processNumericColumn(FieldInfoData.Item item, IndexReader reader, String field, int[] docFilter) throws IOException {
        IntOpenHashSet filter = new IntOpenHashSet(docFilter);
        for (LeafReaderContext ctx : reader.leaves()) {
            class DocCollector
            implements PointValues.IntersectVisitor {
                private final FieldInfoData.Item item;
                private final Map<BytesRef, IntList> doubleValuesToDocs = new HashMap<BytesRef, IntList>();
                private final Int2ObjectMap<IntList> intValuesToDocs = new Int2ObjectOpenHashMap<IntList>();
                private final IntSet docFilter;
                private final boolean intMode;
                private final int docBase;

                public DocCollector(FieldInfoData.Item item, IntSet docFilter, int docBase, boolean intMode) {
                    this.item = item;
                    this.docFilter = docFilter;
                    this.intMode = intMode;
                    this.docBase = docBase;
                }

                void commit() {
                    if (!this.intMode) {
                        IndexAnalyzer.this.createTermList(this.item, this.doubleValuesToDocs);
                    } else {
                        IndexAnalyzer.this.createTermList(this.item, this.intValuesToDocs);
                    }
                }

                @Override
                public void visit(int docId) {
                }

                @Override
                public void visit(int docID, byte[] leaf) {
                    if (this.docFilter != null && !this.docFilter.contains(docID += this.docBase)) {
                        return;
                    }
                    if (this.intMode) {
                        int val = IntPoint.decodeDimension(leaf, 0);
                        IntList docList = this.intValuesToDocs.computeIfAbsent(val, k -> new IntArrayList());
                        docList.add(docID);
                    } else {
                        BytesRef ref = new BytesRef(Arrays.copyOf(leaf, leaf.length));
                        IntList docList = this.doubleValuesToDocs.computeIfAbsent(ref, k -> new IntArrayList());
                        docList.add(docID);
                    }
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            }
            DocCollector collector;
            PointValues values = ctx.reader().getPointValues(field);
            if (values == null) continue;
            if (values.getBytesPerDimension() == 8) {
                collector = new DocCollector(item, filter, ctx.docBase, false);
                values.intersect(collector);
                collector.commit();
                continue;
            }
            if (values.getBytesPerDimension() != 4) continue;
            collector = new DocCollector(item, filter, ctx.docBase, true);
            values.intersect(collector);
            collector.commit();
        }
        return item.terms != null;
    }

    private boolean processDocValueColumn(FieldInfoData.Item item, IndexReader reader, String field, int[] docFilter) throws IOException {
        HashMap<BytesRef, IntList> valuesToDocs = new HashMap<BytesRef, IntList>();
        for (LeafReaderContext ctx : reader.leaves()) {
            NumericDocValues docValues = DocValues.getNumeric(ctx.reader(), field);
            if (docValues == null) continue;
            int docBase = ctx.docBase;
            for (int docId : docFilter) {
                try {
                    if (!docValues.advanceExact(docId - docBase)) {
                    }
                }
                catch (Exception ignored) {}
                continue;
                long val = docValues.longValue();
                byte[] data = new byte[8];
                NumericUtils.longToSortableBytes(val, data, 0);
                BytesRef ref = new BytesRef(data);
                IntList docList = valuesToDocs.computeIfAbsent(ref, k -> new IntArrayList());
                docList.add(docId);
            }
        }
        this.createTermList(item, valuesToDocs);
        return true;
    }

    private boolean processRangeValueColumn(FieldInfoData.Item item, IndexReader reader, String field, int[] docFilter) throws IOException {
        if (!item.fieldName.startsWith("facet_range_")) {
            return false;
        }
        HashMap<BytesRef, IntList> valuesToDocs = new HashMap<BytesRef, IntList>();
        for (LeafReaderContext ctx : reader.leaves()) {
            BinaryDocValues docValues = DocValues.getBinary(ctx.reader(), field);
            if (docValues == null) continue;
            int docBase = ctx.docBase;
            for (int docId : docFilter) {
                try {
                    if (!docValues.advanceExact(docId - docBase)) {
                    }
                }
                catch (Exception ignored) {}
                continue;
                BytesRef val = docValues.binaryValue();
                PDataStream stream = new PDataStream(val);
                int size = stream.readInt();
                stream.readDouble();
                stream.readDouble();
                for (int i = 0; i < size; ++i) {
                    IntList docList;
                    BytesRef ref;
                    byte[] data;
                    double max;
                    double min = stream.readDouble();
                    if (Math.abs(min - (max = stream.readDouble())) < 1.0E-5) {
                        data = new byte[8];
                        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(min), data, 0);
                        ref = new BytesRef(data);
                        docList = valuesToDocs.computeIfAbsent(ref, k -> new IntArrayList());
                        docList.add(docId);
                        continue;
                    }
                    data = new byte[32];
                    NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(min), data, 0);
                    NumericUtils.longToSortableBytes(14L, data, 8);
                    NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(max), data, 16);
                    ref = new BytesRef(data);
                    docList = valuesToDocs.computeIfAbsent(ref, k -> new IntArrayList());
                    docList.add(docId);
                }
            }
        }
        this.createTermList(item, valuesToDocs);
        return true;
    }

    private void createTermList(FieldInfoData.Item item, Map<BytesRef, IntList> valuesToDocs) {
        if (!valuesToDocs.isEmpty()) {
            if (item.terms == null) {
                item.terms = new ArrayList<FieldInfoData.Term>();
            }
            for (Map.Entry<BytesRef, IntList> entry : valuesToDocs.entrySet()) {
                FieldInfoData.Term term = new FieldInfoData.Term();
                BytesRef key = entry.getKey();
                if (key.length < 32) {
                    term.term = String.valueOf(DoublePoint.decodeDimension(key.bytes, 0));
                } else {
                    long longValue = NumericUtils.sortableBytesToLong(key.bytes, 8);
                    int rightHalf = (int)longValue;
                    int nf = rightHalf & 0xF;
                    int pq = rightHalf >> 8;
                    float step = Float.intBitsToFloat((int)(longValue >> 32));
                    double valueMin = DoublePoint.decodeDimension(key.bytes, 0);
                    double valueMax = DoublePoint.decodeDimension(key.bytes, 16);
                    StringBuilder sb = new StringBuilder();
                    sb.append(valueMin);
                    if (valueMax - valueMin > 1.0E-5) {
                        sb.append(" - ");
                        sb.append(valueMax);
                    }
                    if (step != 0.0f) {
                        sb.append(" /");
                        sb.append(step);
                    }
                    if (nf < FieldDefinitions.NumberFlag.values().length) {
                        sb.append(" [");
                        if (nf == FieldDefinitions.NumberFlag.Original.ordinal()) {
                            sb.append("stored");
                        } else if (nf == FieldDefinitions.NumberFlag.Converted.ordinal()) {
                            sb.append("converted");
                        } else if (nf == FieldDefinitions.NumberFlag.OriginalMatching.ordinal()) {
                            sb.append("matching");
                        } else if (nf == FieldDefinitions.NumberFlag.NoUnit.ordinal()) {
                            sb.append("no unit");
                        }
                        if (pq > 0) {
                            sb.append(", ");
                            sb.append(pq);
                        }
                        sb.append("]");
                    }
                    term.term = sb.toString();
                }
                this.fillTermData(item, term, entry.getValue());
            }
        }
    }

    private void createTermList(FieldInfoData.Item item, Int2ObjectMap<IntList> valuesToDocs) {
        if (!valuesToDocs.isEmpty()) {
            if (item.terms == null) {
                item.terms = new ArrayList<FieldInfoData.Term>();
            }
            valuesToDocs.forEach((k, v) -> {
                FieldInfoData.Term term = new FieldInfoData.Term();
                term.term = String.valueOf(k);
                this.fillTermData(item, term, (IntList)v);
            });
        }
    }

    private void fillTermData(FieldInfoData.Item item, FieldInfoData.Term term, IntList value) {
        term.documents = new ArrayList<FieldInfoData.Doc>();
        IntListIterator intListIterator = value.iterator();
        while (intListIterator.hasNext()) {
            int docID = (Integer)intListIterator.next();
            FieldInfoData.Doc doc = new FieldInfoData.Doc();
            doc.id = docID;
            doc.freq = 1;
            term.documents.add(doc);
        }
        item.terms.add(term);
    }

    public FieldInfoData retrieveFieldInfos(int[] docFilter) {
        FieldInfos infos;
        FieldInfoData ret = null;
        if (this.reader != null && (infos = this.reader instanceof LeafReader ? ((LeafReader)this.reader).getFieldInfos() : FieldInfos.getMergedFieldInfos(this.reader)) != null) {
            ret = new FieldInfoData();
            ret.numDocs = this.reader.numDocs();
            ret.numDeletedDocs = this.reader.numDeletedDocs();
            if (infos.size() > 0) {
                ret.fields = new ArrayList<FieldInfoData.Item>();
            }
            for (int i = 0; i < infos.size(); ++i) {
                FieldInfo info = infos.fieldInfo(i);
                FieldInfoData.Item item = new FieldInfoData.Item();
                item.fieldName = info.name;
                try {
                    Terms terms = this.reader instanceof LeafReader ? ((LeafReader)this.reader).terms(info.name) : MultiTerms.getTerms(this.reader, info.name);
                    if (terms != null) {
                        this.processTextualColumn(item, terms, docFilter);
                    } else {
                        DocValuesType dvType = info.getDocValuesType();
                        if (dvType == DocValuesType.NONE) {
                            if (!this.processNumericColumn(item, this.reader, info.name, docFilter)) {
                                item = null;
                            }
                        } else if (dvType == DocValuesType.NUMERIC) {
                            if (!this.processDocValueColumn(item, this.reader, info.name, docFilter)) {
                                item = null;
                            }
                        } else if (dvType == DocValuesType.BINARY && !this.processRangeValueColumn(item, this.reader, info.name, docFilter)) {
                            item = null;
                        }
                    }
                }
                catch (Exception e) {
                    logger.trace(e.getMessage());
                }
                if (item == null) continue;
                ret.fields.add(item);
            }
        }
        return ret;
    }

    public List<ProjectInfoData> retrieveProjectInfos() {
        ArrayList<ProjectInfoData> projects = new ArrayList<ProjectInfoData>();
        if (this.reader != null) {
            Bits bits = MultiBits.getLiveDocs(this.reader);
            HashMap<String, ProjectInfoData> prjLookup = new HashMap<String, ProjectInfoData>();
            HashMap<String, List> docLookup = new HashMap<String, List>();
            BinaryDocValues docValues = null;
            try {
                docValues = MultiDocValues.getBinaryValues(this.reader, "facet_document_id");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int docCount = this.reader.maxDoc();
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            IIndexManager.IIndexReaderData readerData = indexManager.findReaderData(this.reader);
            if (readerData == null) {
                return projects;
            }
            IDocIdIndex docIdIndex = readerData.getDocIdIndex();
            if (docIdIndex == null) {
                return projects;
            }
            for (int d = 0; d < docCount; ++d) {
                try {
                    if (bits != null && !bits.get(d)) continue;
                    IDocIdIndex.LineData lineData = docIdIndex.findLineData(d);
                    if (lineData == null) {
                        BytesRef data;
                        if (docValues == null) continue;
                        Document doc = this.reader.document(d);
                        String contents = doc.get("document");
                        if (!docValues.advanceExact(d) || (data = docValues.binaryValue()) == null) continue;
                        try {
                            PDataStream stream = new PDataStream(data);
                            stream.readString();
                            String prjPath = stream.readString();
                            int lineCount = stream.readInt();
                            IntArrayList lineIds = new IntArrayList(lineCount);
                            for (int i = 0; i < lineCount; ++i) {
                                int lineId = stream.readInt();
                                lineIds.add(lineId);
                            }
                            ProjectInfoData.DocInfo docData = new ProjectInfoData.DocInfo();
                            docData.docId = d;
                            docData.column = doc.get("column");
                            docData.lineIds = lineIds;
                            docData.content = contents;
                            List itemList = docLookup.computeIfAbsent(prjPath, k -> new ArrayList());
                            itemList.add(docData);
                        }
                        catch (Exception stream) {}
                        continue;
                    }
                    String path = lineData.path;
                    ProjectInfoData prjInfo = (ProjectInfoData)prjLookup.get(path);
                    if (prjInfo == null) {
                        prjInfo = new ProjectInfoData();
                        prjInfo.path = path;
                        prjLookup.put(path, prjInfo);
                    }
                    int lineId = lineData.lineId;
                    int lineSubId = lineData.lineSubId;
                    String varset = lineData.varset;
                    ProjectInfoData.Line line = null;
                    if (prjInfo.lines == null) {
                        prjInfo.lines = new ArrayList<ProjectInfoData.Line>();
                    } else {
                        line = prjInfo.lines.stream().filter(l -> l.lineId == lineId && l.lineSubId == lineSubId && (l.varset == null && varset == null || l.varset != null && l.varset.equals(varset))).findAny().orElse(null);
                    }
                    if (line == null) {
                        line = new ProjectInfoData.Line();
                        line.docId = d;
                        line.lineId = lineId;
                        line.lineSubId = lineSubId;
                        line.varset = varset;
                        prjInfo.lines.add(line);
                        continue;
                    }
                    line.docId = d;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (Map.Entry entry : prjLookup.entrySet()) {
                List docInfos = (List)docLookup.get(entry.getKey());
                if (docInfos != null) {
                    ((ProjectInfoData)entry.getValue()).documents = docInfos;
                }
                projects.add((ProjectInfoData)entry.getValue());
            }
        }
        return projects;
    }
}

