/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.util;

import de.cadenas.catalogsearch.api.IFacetsResult;
import de.cadenas.catalogsearch.api.ISearchResult;
import de.cadenas.catalogsearch.api.ISearchResultError;
import de.cadenas.catalogsearch.api.ISearchResultFilter;
import de.cadenas.catalogsearch.api.ISearchResultFilterValue;
import de.cadenas.catalogsearch.api.ISearchResultItem;
import de.cadenas.util.PDataStream;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class BinarySerialization {
    public static byte[] serialize(ISearchResult result, long startTime) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PDataStream stream = new PDataStream(outStream);
        stream.write(12);
        stream.write(0);
        stream.write(result.getTotalHitCount());
        stream.write(result.getProjectCount());
        stream.write(result.getCommonDirectory());
        Object2IntOpenHashMap<String> stringTable = new Object2IntOpenHashMap<String>();
        for (ISearchResultItem iSearchResultItem : result.getItems()) {
            stringTable.computeIntIfAbsent(iSearchResultItem.getCatalog(), k -> stringTable.size());
            stringTable.computeIntIfAbsent(iSearchResultItem.getPath(), k -> stringTable.size());
        }
        stream.write(stringTable.size());
        for (Object2IntMap.Entry entry : stringTable.object2IntEntrySet()) {
            stream.write(entry.getIntValue());
            stream.write((String)entry.getKey());
        }
        stream.write(result.getItems().size());
        for (ISearchResultItem iSearchResultItem : result.getItems()) {
            stream.write(iSearchResultItem.getScore());
            stream.write(iSearchResultItem.getExplanation());
            stream.write(stringTable.getInt(iSearchResultItem.getCatalog()));
            stream.write(stringTable.getInt(iSearchResultItem.getPath()));
            stream.write(iSearchResultItem.getLineId());
            stream.write(iSearchResultItem.getLineSubId());
            stream.write(iSearchResultItem.getVarset());
            stream.write(iSearchResultItem.hidesOriginalLine());
            List<ISearchResultItem.DocumentInfo> docInfos = iSearchResultItem.getDocumentInfos();
            if (docInfos != null && !docInfos.isEmpty()) {
                stream.write(docInfos.size());
                for (ISearchResultItem.DocumentInfo docInfo : docInfos) {
                    stream.write(docInfo.columnName);
                    stream.write(docInfo.documentPath);
                    stream.write(docInfo.basePath);
                    stream.write(docInfo.documentRelPath);
                    if (docInfo.fragments != null && docInfo.fragments.length > 0) {
                        stream.write(docInfo.fragments.length);
                        for (String fragment : docInfo.fragments) {
                            stream.write(fragment);
                        }
                        continue;
                    }
                    stream.write(0);
                }
                continue;
            }
            stream.write(0);
        }
        BinarySerialization.serializeFilters(stream, result.getFilters());
        BinarySerialization.serializeChildFolderFilters(stream, result.getChildFolderFilter());
        if (result.getErrors() == null) {
            stream.write(0);
        } else {
            stream.write(result.getErrors().size());
            for (ISearchResultError iSearchResultError : result.getErrors()) {
                stream.write(iSearchResultError.getID());
                stream.write(iSearchResultError.getNo());
                stream.write(iSearchResultError.getArguments().length);
                for (String arg : iSearchResultError.getArguments()) {
                    stream.write(arg);
                }
                stream.write(iSearchResultError.getData().length);
                for (String data : iSearchResultError.getData()) {
                    stream.write(data);
                }
            }
        }
        long elapsed = System.nanoTime() - startTime;
        stream.write(elapsed);
        stream.write(result.getSearchId());
        stream.write(result.getMoreVarFacetsAvailable());
        return outStream.toByteArray();
    }

    public static byte[] serialize(IFacetsResult result) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PDataStream stream = new PDataStream(outStream);
        BinarySerialization.serializeFilters(stream, result.getFilters());
        stream.write(result.getMoreVarFacetsAvailable());
        stream.write(result.getCommonDirectory());
        return outStream.toByteArray();
    }

    private static void serializeFilters(PDataStream stream, List<ISearchResultFilter> filters) throws IOException {
        stream.write(filters.size());
        for (ISearchResultFilter filter : filters) {
            stream.write(filter.getName());
            stream.write(filter.getMatchCount());
            stream.write(filter.isRangeFilter());
            stream.write(filter.useValueList() && !filter.useMinMax());
            stream.write(filter.isErp());
            List<ISearchResultFilterValue> values = filter.getValues();
            stream.write(values.size());
            for (ISearchResultFilterValue value : values) {
                stream.write(value.getValue());
                stream.write(value.getMatchCount());
            }
        }
    }

    private static void serializeChildFolderFilters(PDataStream stream, List<String> childFilters) throws IOException {
        if (childFilters == null) {
            stream.write(0);
        } else {
            stream.write(childFilters.size());
            for (String filter : childFilters) {
                stream.write(filter);
            }
        }
    }
}

