/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;

public class ValueRangeQuery
extends Query {
    public final String field;
    public final boolean searchOriginalValue;
    public final boolean searchExactValue;
    public final int physicalQuantity;
    public double minValue;
    public double maxValue;
    public double originalValue = Double.NaN;
    public final byte[] ranges;
    public final int bytesPerDim;

    ValueRangeQuery(String field, double min, double max, boolean searchConverted, int physicalQuantity, boolean exactSearch) {
        this.field = field;
        this.minValue = min;
        this.maxValue = max;
        this.searchOriginalValue = !searchConverted;
        this.searchExactValue = exactSearch;
        this.physicalQuantity = physicalQuantity;
        this.ranges = new byte[16];
        ValueRangeQuery.encode(min, this.ranges, 0);
        ValueRangeQuery.encode(max, this.ranges, 8);
        this.bytesPerDim = 8;
    }

    ValueRangeQuery(String field, double min, double max) {
        this(field, min, max, false, 0, false);
    }

    public double getMin() {
        return this.minValue;
    }

    public double getMax() {
        return this.maxValue;
    }

    boolean isSearchOriginalValue() {
        return this.searchOriginalValue;
    }

    public static Query newIntersectsQuery(String field, double min, double max, boolean searchConverted, int physicalQuantity) {
        return new ValueRangeQuery(field, min, max, searchConverted, physicalQuantity, false);
    }

    public static Query newIntersectsQuery(String field, double min, double max, double originalValue, boolean searchConverted, int physicalQuantity, boolean exactSearch) {
        ValueRangeQuery query = new ValueRangeQuery(field, min, max, searchConverted, physicalQuantity, exactSearch);
        query.originalValue = originalValue;
        return query;
    }

    private static void encode(double val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(val), bytes, offset);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            private ValueRangeIntersectVisitor getIntersectVisitor(DocIdSetBuilder result) {
                return new ValueRangeIntersectVisitor(result, new ValueRangeMatcher(ValueRangeQuery.this.searchOriginalValue, ValueRangeQuery.this.physicalQuantity, ValueRangeQuery.this.searchExactValue));
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                ValueRangeMatcher matcher;
                int match;
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(ValueRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(ValueRangeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                boolean allDocsMatch = false;
                float scoreMultiplier = 1.0f;
                byte[] minPackedValue = values.getMinPackedValue();
                if (values.getDocCount() == reader.maxDoc() && ((match = (matcher = new ValueRangeMatcher(ValueRangeQuery.this.searchOriginalValue, ValueRangeQuery.this.physicalQuantity, ValueRangeQuery.this.searchExactValue)).compare(ValueRangeQuery.this.ranges, minPackedValue, values.getMaxPackedValue(), minPackedValue.length == 32 ? 2 : 1, ValueRangeQuery.this.bytesPerDim)) & 0xFFFF) == PointValues.Relation.CELL_INSIDE_QUERY.ordinal()) {
                    if (match >> 16 == 1) {
                        scoreMultiplier = 0.5f;
                    }
                    allDocsMatch = true;
                }
                final float sc = this.score() * scoreMultiplier;
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, sc, scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final ValueRangeIntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, ValueRangeQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        if (this.visitor.lowPrioDocs.isEmpty()) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                        }
                        return new ValueRangeScorer(weight, this.score(), this.visitor.lowPrioDocs, iterator);
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.ranges);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((ValueRangeQuery)this.getClass().cast(o));
    }

    protected boolean equalsTo(ValueRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.minValue == other.minValue && this.maxValue == other.maxValue;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("<ranges:");
        sb.append(this.toString(this.ranges));
        sb.append('>');
        return sb.toString();
    }

    private String toString(byte[] ranges) {
        int offset = 0;
        double d = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(ranges, offset));
        offset = ranges.length / 2;
        double d2 = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(ranges, offset));
        return "[" + d + " : " + d2 + "]";
    }

    private static class ValueRangeScorer
    extends Scorer {
        private final IntSet lowPrioDocs;
        private final DocIdSetIterator disi;
        private final float defaultScore;

        public ValueRangeScorer(Weight weight, float defaultScore, IntSet lowPrioDocs, DocIdSetIterator disi) {
            super(weight);
            this.lowPrioDocs = lowPrioDocs;
            this.disi = disi;
            this.defaultScore = defaultScore;
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.defaultScore;
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.disi;
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return null;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public float score() throws IOException {
            if (this.lowPrioDocs.contains(this.disi.docID())) {
                return this.defaultScore * 0.5f;
            }
            return this.defaultScore;
        }
    }

    class ValueRangeIntersectVisitor
    implements PointValues.IntersectVisitor {
        DocIdSetBuilder.BulkAdder adder;
        ValueRangeMatcher matcher;
        DocIdSetBuilder result;
        IntSet lowPrioDocs = new IntOpenHashSet();
        boolean lowPriosMode = false;

        ValueRangeIntersectVisitor(DocIdSetBuilder result, ValueRangeMatcher matcher) {
            this.result = result;
            this.matcher = matcher;
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) throws IOException {
            this.adder.add(docID);
            if (this.lowPriosMode) {
                this.lowPrioDocs.add(docID);
            }
        }

        @Override
        public void visit(int docID, byte[] leaf) throws IOException {
            int numDims = leaf.length == 32 ? 2 : 1;
            int match = this.matcher.matches(ValueRangeQuery.this.ranges, leaf, numDims, ValueRangeQuery.this.bytesPerDim);
            if (match > 0) {
                this.adder.add(docID);
                if (match > 1) {
                    this.lowPrioDocs.add(docID);
                }
            }
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] leaf) throws IOException {
            int numDims = leaf.length == 32 ? 2 : 1;
            int match = this.matcher.matches(ValueRangeQuery.this.ranges, leaf, numDims, ValueRangeQuery.this.bytesPerDim);
            if (match > 0) {
                int docID;
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    this.adder.add(docID);
                    if (match <= 1) continue;
                    this.lowPrioDocs.add(docID);
                }
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.lowPriosMode = false;
            int numDims = minPackedValue.length == 32 ? 2 : 1;
            int match = this.matcher.compare(ValueRangeQuery.this.ranges, minPackedValue, maxPackedValue, numDims, ValueRangeQuery.this.bytesPerDim);
            if (match >> 16 == 1) {
                this.lowPriosMode = true;
            }
            return PointValues.Relation.values()[match & 0xFFFF];
        }
    }

    private record ValueRangeMatcher(boolean searchOriginalValue, int physicalQuantity, boolean searchExactValue) {
        private boolean pointMatchesQuery(byte[] value, int offset) {
            int pq;
            if (value[offset] != -128) {
                return false;
            }
            long longValue = NumericUtils.sortableBytesToLong(value, offset);
            int rightHalf = (int)longValue;
            int nf = rightHalf & 0xFF;
            if ((nf &= 0xF) == FieldDefinitions.NumberFlag.Converted.ordinal() && this.searchOriginalValue) {
                return false;
            }
            if (!(nf != FieldDefinitions.NumberFlag.Original.ordinal() && nf != FieldDefinitions.NumberFlag.NoUnit.ordinal() || this.searchOriginalValue)) {
                return false;
            }
            if (!this.searchOriginalValue && (pq = rightHalf >> 8) != this.physicalQuantity) {
                return false;
            }
            for (int i = offset + 1; i < offset + 4; ++i) {
                if (value[i] == 0) continue;
                return false;
            }
            return true;
        }

        private boolean pointMatchesQuery(byte[] value) {
            if (value.length == 16) {
                return true;
            }
            return this.pointMatchesQuery(value, 8) && this.pointMatchesQuery(value, 24);
        }

        public int compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim, int dim) {
            int minOffset = dim * bytesPerDim;
            int maxOffset = minOffset + bytesPerDim * numDims;
            if (Arrays.compareUnsigned(queryPackedValue, 8, 16, minPackedValue, minOffset, minOffset + bytesPerDim) < 0 || Arrays.compareUnsigned(queryPackedValue, 0, 8, maxPackedValue, maxOffset, maxOffset + bytesPerDim) > 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY.ordinal();
            }
            if (this.pointMatchesQuery(maxPackedValue) && Arrays.compareUnsigned(queryPackedValue, 8, 16, maxPackedValue, minOffset, minOffset + bytesPerDim) >= 0 && this.pointMatchesQuery(minPackedValue) && Arrays.compareUnsigned(queryPackedValue, 8, 16, minPackedValue, maxOffset, maxOffset + bytesPerDim) <= 0) {
                int ret = PointValues.Relation.CELL_INSIDE_QUERY.ordinal();
                if (minPackedValue.length > 16) {
                    int nf = minPackedValue[15];
                    if ((nf >>= 4) == 1) {
                        ret = 0x10000 | ret;
                    }
                }
                return ret;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY.ordinal();
        }

        public boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim, int dim) {
            int minOffset = dim * bytesPerDim;
            int maxOffset = minOffset + bytesPerDim * numDims;
            return Arrays.compareUnsigned(queryPackedValue, 8, 16, packedValue, minOffset, minOffset + bytesPerDim) >= 0 && Arrays.compareUnsigned(queryPackedValue, 0, 8, packedValue, maxOffset, maxOffset + bytesPerDim) <= 0;
        }

        public int compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim) {
            int dim = 0;
            if (minPackedValue.length == 16) {
                return this.compare(queryPackedValue, minPackedValue, maxPackedValue, 1, bytesPerDim, dim);
            }
            return this.compare(queryPackedValue, minPackedValue, maxPackedValue, 2, bytesPerDim, dim);
        }

        public int matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim) {
            if (this.matches(queryPackedValue, packedValue, numDims, bytesPerDim, 0)) {
                int pq;
                if (packedValue.length == 16) {
                    return 1;
                }
                if (this.searchExactValue && Arrays.compareUnsigned(packedValue, 0, 16, packedValue, 16, 32) != 0) {
                    return 0;
                }
                long longValue = NumericUtils.sortableBytesToLong(packedValue, 8);
                int rightHalf = (int)longValue;
                int nf = rightHalf & 0xFF;
                int lowPrio = nf >> 4;
                if ((nf &= 0xF) == FieldDefinitions.NumberFlag.Converted.ordinal() && this.searchOriginalValue) {
                    return 0;
                }
                if (!(nf != FieldDefinitions.NumberFlag.Original.ordinal() && nf != FieldDefinitions.NumberFlag.NoUnit.ordinal() || this.searchOriginalValue)) {
                    return 0;
                }
                if (!this.searchOriginalValue && (pq = rightHalf >> 8) != this.physicalQuantity) {
                    return 0;
                }
                float step = Float.intBitsToFloat((int)(longValue >> 32));
                if (step > 0.0f) {
                    double valueMax;
                    double valueMin = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(queryPackedValue, 0));
                    if (valueMin == (valueMax = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(queryPackedValue, 8)))) {
                        boolean matches;
                        double indexMin = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(packedValue, 0));
                        double x = (valueMin - indexMin) / (double)step;
                        boolean bl = matches = Math.abs(x - (double)Math.round(x)) <= 0.1;
                        if (matches) {
                            return 1 + lowPrio;
                        }
                        return 0;
                    }
                    if (valueMin != Double.NEGATIVE_INFINITY && valueMax != Double.POSITIVE_INFINITY) {
                        boolean matches;
                        if (valueMax - valueMin > (double)step) {
                            return 1 + lowPrio;
                        }
                        double indexMin = NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(packedValue, 0));
                        double x = (float)Math.round((valueMin - indexMin) / (double)step) * step;
                        double y = (float)Math.round((valueMax - indexMin) / (double)step) * step;
                        boolean bl = matches = Math.abs(x - (valueMin - indexMin)) < 1.0E-5 && Math.abs(y - (valueMax - indexMin)) < 1.0E-5;
                        if (matches) {
                            return 1 + lowPrio;
                        }
                        return 0;
                    }
                    return 1 + lowPrio;
                }
                return 1 + lowPrio;
            }
            return 0;
        }
    }
}

