/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.impl.SearchResultItemImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.analysis.helper.Varset;
import de.cadenas.catalogsearch.lucene.index.MemoryIndex;
import de.cadenas.catalogsearch.lucene.index.valuerange.ValueRangeData;
import de.cadenas.catalogsearch.lucene.queryparser.BooleanQueryBuilder;
import de.cadenas.catalogsearch.lucene.queryparser.IFieldQueryVisitor;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.util.Containers;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PGenericPair;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.compress.LZ4;

public class ResultVarsetBuilder {
    private final List<PGenericPair<String, String>> queryTerms;
    private final List<NumericRange> queryRanges;
    private final Map<BytesRef, Map<String, List<String>>> processedValueRanges = new HashMap<BytesRef, Map<String, List<String>>>();
    private final Map<String, Query> queriesPerField = new HashMap<String, Query>();
    private MemoryIndex memoryIndex = null;
    private QueryLookup queryLookup = null;

    private NumericRange numericRangeFromFieldDescription(String field, String encodedData, int index) {
        int sep;
        int start;
        String substr;
        if ((field.startsWith("col_number_") || field.equals("numbervalues")) && (substr = encodedData.substring(index + 1)).startsWith("<") && (start = substr.indexOf(91)) != -1 && (sep = substr.indexOf(58, start + 1)) != -1) {
            String sFrom = substr.substring(start + 1, sep);
            double from = NumUtils.getNumeric(sFrom);
            double to = Double.POSITIVE_INFINITY;
            int end = substr.indexOf(93, sep + 1);
            if (end != -1) {
                String sTo = substr.substring(sep + 1, end);
                to = NumUtils.getNumeric(sTo);
            }
            NumericRange range = new NumericRange(field, from, to);
            return range;
        }
        return null;
    }

    private double findTermInStoredValue(Term term, PDataStream valueStream) {
        BytesRef br = new BytesRef();
        while (!valueStream.atEnd()) {
            valueStream.readVInt();
            valueStream.readBytes(br);
            if (br.compareTo(term.bytes()) != 0) continue;
            return 1.0;
        }
        return 0.0;
    }

    private List<VarCandidate> findTermInValueRangeDef(String language, String variable, String fieldName, ValueRangeData vrData, Query query) {
        ArrayList<VarCandidate> matchList = null;
        for (int i = 0; i < vrData.values.size(); ++i) {
            ValueRangeData.Item item = vrData.values.get(i);
            byte[] value = null;
            value = vrData.isTranslated ? item.translatedValues.get(language) : item.tokenizedValue;
            if (value == null) continue;
            PDataStream valueStream = new PDataStream(value, 0, value.length);
            double matchesScore = 0.0;
            if (query instanceof TermQuery) {
                Term term = ((TermQuery)query).getTerm();
                matchesScore = this.findTermInStoredValue(term, valueStream);
                if (matchesScore > 0.0 && value.length > 0) {
                    matchesScore /= (double)value.length;
                }
            } else {
                this.memoryIndex.reset();
                this.memoryIndex.addField(fieldName, valueStream);
                float score = this.memoryIndex.search(query);
                matchesScore = score;
            }
            if (!(matchesScore > 0.0)) continue;
            if (item.internalValue == null) {
                item.internalValue = "";
            }
            VarCandidate match = new VarCandidate(variable.toUpperCase(), item.internalValue, i == 0, matchesScore);
            if (matchList == null) {
                matchList = new ArrayList<VarCandidate>();
            }
            matchList.add(match);
        }
        return matchList;
    }

    private List<VarCandidate> findInternalValue(String fieldName, String matchingTerm, Map<String, ValueRangeData> vrData) {
        ValueRangeData data;
        PGenericPair<String, String> langAndVar;
        if (fieldName.startsWith("textvalues")) {
            ArrayList<VarCandidate> candidates = null;
            String lang = FieldDefinitions.getLanguageOfField(fieldName);
            Query query = this.queriesPerField.get(fieldName);
            if (query == null) {
                PGenericPair<Query, String> qf = this.queryLookup.lookupQuery(matchingTerm, fieldName, FieldDefinitions.getLanguageGroup(lang));
                query = (Query)qf.first;
                fieldName = (String)qf.second;
            }
            if (query == null) {
                return null;
            }
            for (Map.Entry entry : vrData.entrySet()) {
                List<VarCandidate> varCandidates;
                if (((ValueRangeData)entry.getValue()).isRange || (varCandidates = this.findTermInValueRangeDef(lang, (String)entry.getKey(), fieldName, (ValueRangeData)entry.getValue(), query)) == null || varCandidates.isEmpty()) continue;
                if (candidates == null) {
                    candidates = new ArrayList<VarCandidate>();
                }
                candidates.addAll(varCandidates);
            }
            return candidates;
        }
        if ((fieldName.startsWith("col_text_") || fieldName.startsWith("facet_text")) && (langAndVar = FieldDefinitions.getLanguageAndVarName(fieldName)) != null && (data = vrData.get(((String)langAndVar.second).toUpperCase())) != null && !data.isRange) {
            Query query = this.queriesPerField.get(fieldName);
            if (query == null) {
                PGenericPair<Query, String> qf = this.queryLookup.lookupQuery(matchingTerm, fieldName, FieldDefinitions.getLanguageGroup((String)langAndVar.first));
                query = (Query)qf.first;
                fieldName = (String)qf.second;
            }
            if (query != null) {
                return this.findTermInValueRangeDef((String)langAndVar.first, (String)langAndVar.second, fieldName, data, query);
            }
        }
        return null;
    }

    private double findIntersection(NumericRange searchRange, double vrMin, double vrMax, double vrStep) {
        double min = vrStep != 0.0 ? Math.max((double)Math.round((searchRange.min - vrMin) / vrStep) * vrStep + vrMin, vrMin) : Math.max(searchRange.min, vrMin);
        double max = Math.min(searchRange.max, vrMax);
        if (min < searchRange.min) {
            min += vrStep;
        }
        if (min - max > 1.0E-4) {
            return Double.NaN;
        }
        return min;
    }

    private void processRangeList(ValueRangeData data, NumericRange foundRange, String varName, Map<String, List<String>> candidates) {
        double f = 1.0;
        if (foundRange.searchConverted) {
            f = data.conversionFactor;
        }
        if (f <= 0.0) {
            f = 1.0;
        }
        if (data.numRange != null) {
            for (int i = 0; i < data.numRange.size(); ++i) {
                ValueRangeData.Range range = (ValueRangeData.Range)data.numRange.get(i);
                double intersection = this.findIntersection(foundRange, range.min * f, range.max * f, range.step * f);
                if (Double.isNaN(intersection)) continue;
                if (i == 0 && intersection == range.min) {
                    return;
                }
                if (foundRange.searchConverted) {
                    double inverseFactor = 1.0 / f;
                    intersection *= inverseFactor;
                }
                ArrayList<String> valueList = new ArrayList<String>();
                if (range.step != 0.0) {
                    valueList.add(Double.toString(intersection));
                } else {
                    NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
                    format.setMaximumFractionDigits(3);
                    format.setGroupingUsed(false);
                    valueList.add(format.format(intersection));
                }
                candidates.put(varName, valueList);
                break;
            }
        }
    }

    private void findMatchingRangeCandidates(Map<String, ValueRangeData> vrData, List<NumericRange> numericFields, Map<String, List<String>> candidates) {
        for (NumericRange foundRange : numericFields) {
            int index;
            ValueRangeData data;
            if (foundRange.field.equals("numbervalues")) {
                for (Map.Entry<String, ValueRangeData> vrItem : vrData.entrySet()) {
                    data = vrItem.getValue();
                    if (!data.isRange || data.numRange == null) continue;
                    this.processRangeList(data, foundRange, vrItem.getKey(), candidates);
                }
                continue;
            }
            if (!foundRange.field.startsWith("col_number_") || (index = foundRange.field.lastIndexOf(95)) == -1) continue;
            String varName = foundRange.field.substring(index + 1);
            data = vrData.get(varName = varName.toUpperCase());
            if (data == null) continue;
            this.processRangeList(data, foundRange, varName, candidates);
        }
    }

    private Map<String, List<String>> getCandidatesPerVar(Map<String, ValueRangeData> vrData, List<PGenericPair<String, String>> fieldInfos, List<NumericRange> numericFields) {
        record CandidateValue(String internalValue, boolean defaultValue, boolean valueFromVariable) {
        }
        HashMap<String, List> candidatesPerVar = new HashMap<String, List>();
        for (PGenericPair<String, String> fieldInfo : fieldInfos) {
            boolean isVarField;
            List<VarCandidate> fieldCandidates = this.findInternalValue((String)fieldInfo.first, (String)fieldInfo.second, vrData);
            if (fieldCandidates == null || fieldCandidates.isEmpty()) continue;
            boolean bl = isVarField = ((String)fieldInfo.first).startsWith("facet_") || ((String)fieldInfo.first).startsWith("col_text");
            if (fieldCandidates.size() > 1) {
                fieldCandidates.sort(Comparator.comparingDouble(l -> l.score).reversed());
            }
            HashMap<String, List> currentCandidates = new HashMap<String, List>();
            for (VarCandidate varCandidate : fieldCandidates) {
                List currentList = currentCandidates.computeIfAbsent(varCandidate.varName, k -> new ArrayList());
                currentList.add(new CandidateValue(varCandidate.internalValue, varCandidate.defaultValue, isVarField));
            }
            for (Map.Entry entry : currentCandidates.entrySet()) {
                CandidateValue value;
                int i;
                String varName = (String)entry.getKey();
                List currentList = (List)entry.getValue();
                List candidateList = (List)candidatesPerVar.get(varName);
                if (candidateList == null) {
                    candidatesPerVar.put(varName, currentList);
                    continue;
                }
                if (isVarField) {
                    for (i = candidateList.size() - 1; i >= 0; --i) {
                        value = (CandidateValue)candidateList.get(i);
                        if (value.valueFromVariable) continue;
                        candidateList.remove(i);
                    }
                    candidateList.addAll(currentList);
                    continue;
                }
                for (i = candidateList.size() - 1; i >= 0; --i) {
                    value = (CandidateValue)candidateList.get(i);
                    if (value.valueFromVariable || !currentList.stream().noneMatch(s -> s.internalValue.equals(value.internalValue))) continue;
                    candidateList.remove(i);
                }
            }
        }
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (Map.Entry item : candidatesPerVar.entrySet()) {
            ArrayList valueList = new ArrayList();
            ((List)item.getValue()).stream().filter(val -> !val.defaultValue).forEach(val -> valueList.add(val.internalValue));
            if (valueList.isEmpty()) continue;
            resultMap.put((String)item.getKey(), valueList);
        }
        if (numericFields != null) {
            this.findMatchingRangeCandidates(vrData, numericFields, resultMap);
        }
        return resultMap;
    }

    public ResultVarsetBuilder(Query query) {
        class TermCollector
        extends QueryVisitor
        implements IFieldQueryVisitor {
            final List<PGenericPair<String, String>> termList = new ArrayList<PGenericPair<String, String>>();
            final List<NumericRange> rangeList = new ArrayList<NumericRange>();

            TermCollector() {
            }

            List<PGenericPair<String, String>> getFoundTerms() {
                return this.termList;
            }

            List<NumericRange> getFoundRanges() {
                return this.rangeList;
            }

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                for (Term term : terms) {
                    String termText;
                    String field = term.field();
                    if (field.equals("$varfacets")) {
                        termText = term.text();
                        int index = termText.indexOf(31);
                        if (index <= 0) continue;
                        String fieldName = termText.substring(0, index);
                        String text = termText.substring(index + 1);
                        this.termList.add(new PGenericPair<String, String>(fieldName, text));
                        continue;
                    }
                    if (!field.startsWith("col_text_") && !field.startsWith("textvalues") || (termText = term.text()).endsWith("#")) continue;
                    this.termList.add(new PGenericPair<String, String>(term.field(), term.text()));
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitLeaf(Query query) {
                if (query instanceof DrillDownQuery) {
                    DrillDownQuery ddq = (DrillDownQuery)query;
                    try {
                        Field baseField = ddq.getClass().getDeclaredField("baseQuery");
                        baseField.setAccessible(true);
                        Query baseQuery = (Query)baseField.get(ddq);
                        if (baseQuery != null) {
                            baseQuery.visit(this);
                        }
                        baseField = ddq.getClass().getDeclaredField("dimQueries");
                        baseField.setAccessible(true);
                        List dimQueries = (List)baseField.get(ddq);
                        if (dimQueries == null || dimQueries.isEmpty()) return;
                        for (BooleanQuery.Builder builder : dimQueries) {
                            BooleanQuery bq = builder.build();
                            bq.visit(this);
                        }
                        return;
                    }
                    catch (Exception baseField) {
                        return;
                    }
                } else if (query instanceof ValueRangeQuery) {
                    ValueRangeQuery vrQuery = (ValueRangeQuery)query;
                    String field = vrQuery.field;
                    if (!field.startsWith("col_number_") && !field.equals("numbervalues")) return;
                    double originalValue = vrQuery.originalValue;
                    NumericRange range = !Double.isNaN(originalValue) ? new NumericRange(field, originalValue, originalValue) : new NumericRange(field, vrQuery.getMin(), vrQuery.getMax());
                    range.searchConverted = !vrQuery.isSearchOriginalValue();
                    this.rangeList.add(range);
                    return;
                } else {
                    NumericRange range;
                    String field;
                    String encodedData = query.toString();
                    int index = encodedData.indexOf(58);
                    if (index <= 0 || !(field = encodedData.substring(0, index)).startsWith("col_number_") && !field.equals("numbervalues") || (range = ResultVarsetBuilder.this.numericRangeFromFieldDescription(field, encodedData, index)) == null) return;
                    this.rangeList.add(range);
                }
            }

            @Override
            public void visit(String field, Query query) {
                if (field.equals("$varfacets") || field.startsWith("col_text_") || field.startsWith("textvalues")) {
                    ResultVarsetBuilder.this.queriesPerField.put(field, query);
                    this.termList.add(new PGenericPair<String, Object>(field, null));
                }
            }
        }
        TermCollector visitor = new TermCollector();
        query.visit(visitor);
        this.queryTerms = visitor.getFoundTerms();
        this.queryRanges = visitor.getFoundRanges();
        if (!this.queryTerms.isEmpty() || !this.queryRanges.isEmpty()) {
            this.memoryIndex = new MemoryIndex();
            this.queryLookup = new QueryLookup();
        }
    }

    public void processItem(SearchResultItemImpl resultItem, BytesRef rawVrData, boolean linkDbIndex) {
        if (this.queryTerms.isEmpty() && this.queryRanges.isEmpty()) {
            return;
        }
        Map<String, List<String>> candidatesPerVar = this.processedValueRanges.get(rawVrData);
        if (candidatesPerVar == null) {
            HashMap<String, ValueRangeData> vrData = new HashMap<String, ValueRangeData>();
            try {
                ByteArrayDataInput stream = new ByteArrayDataInput(rawVrData.bytes, rawVrData.offset, rawVrData.length);
                int decompressedLength = stream.readVInt();
                byte[] decompressedData = new byte[decompressedLength];
                LZ4.decompress(stream, decompressedLength, decompressedData, 0);
                stream = new ByteArrayDataInput(decompressedData);
                int count = stream.readInt();
                for (int i = 0; i < count; ++i) {
                    String fieldName = stream.readString();
                    ValueRangeData data = new ValueRangeData();
                    if (!data.loadFromStream(stream)) {
                        return;
                    }
                    if (linkDbIndex && !data.isFm) continue;
                    vrData.put(fieldName, data);
                }
            }
            catch (IOException e) {
                return;
            }
            if (vrData.isEmpty()) {
                return;
            }
            candidatesPerVar = this.getCandidatesPerVar(vrData, this.queryTerms, this.queryRanges);
            this.processedValueRanges.put(rawVrData, candidatesPerVar);
        }
        if (!candidatesPerVar.isEmpty()) {
            Varset varset = new Varset(resultItem.varset);
            boolean changed = false;
            for (Map.Entry<String, List<String>> varItem : candidatesPerVar.entrySet()) {
                List<String> valueCandidates = varItem.getValue();
                if (valueCandidates.isEmpty()) continue;
                varset.addVarValue(varItem.getKey(), valueCandidates.get(0));
                changed = true;
            }
            if (changed) {
                resultItem.varset = varset.makeVarset();
            }
        }
    }

    private static class NumericRange {
        String field;
        double min;
        double max;
        boolean searchConverted = false;

        public NumericRange(String field, double min, double max) {
            this.field = field;
            this.min = min;
            this.max = max;
        }
    }

    private static class VarCandidate {
        public String varName;
        public String internalValue;
        public boolean defaultValue;
        public double score = 0.0;

        public VarCandidate(String varName, String internalValue, boolean defaultValue, double score) {
            this.varName = varName;
            this.internalValue = internalValue;
            this.defaultValue = defaultValue;
            this.score = score;
        }
    }

    private static class QueryLookup {
        private final List<TokenizedData> data = new ArrayList<TokenizedData>();

        private QueryLookup() {
        }

        private Query createQuery(String fieldName, String matchingTerm) {
            FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(true);
            TokenStream stream = analyzer.tokenStream(fieldName, matchingTerm);
            try {
                stream.reset();
                BooleanQueryBuilder builder = new BooleanQueryBuilder();
                TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
                PositionIncrementAttribute posIncrAttribute = stream.addAttribute(PositionIncrementAttribute.class);
                while (stream.incrementToken()) {
                    String searchTerm;
                    int posIncr = posIncrAttribute.getPositionIncrement();
                    if (posIncr == 0 || (searchTerm = termAtt.toString()).isEmpty()) continue;
                    TermQuery tq = new TermQuery(new Term(fieldName, searchTerm));
                    builder.add(tq);
                }
                stream.close();
                if (!builder.isEmpty()) {
                    return builder.build();
                }
            }
            catch (IOException e) {
                return null;
            }
            return null;
        }

        public PGenericPair<Query, String> lookupQuery(String value, String fieldName, FieldDefinitions.LanguageGroup group) {
            for (TokenizedData item : this.data) {
                if (!item.value.equalsIgnoreCase(value)) continue;
                for (int i = 0; i < item.langGroups.size(); ++i) {
                    if (item.langGroups.getInt(i) != group.ordinal()) continue;
                    return item.queries.get(i);
                }
                item.langGroups.add(group.ordinal());
                Query query = this.createQuery(fieldName, value);
                PGenericPair<Query, String> ret = new PGenericPair<Query, String>(query, fieldName);
                item.queries.add(ret);
                return ret;
            }
            TokenizedData item = new TokenizedData();
            item.value = value;
            item.langGroups = new Containers.IntList();
            item.langGroups.add(group.ordinal());
            Query query = this.createQuery(fieldName, value);
            item.queries = new ArrayList<PGenericPair<Query, String>>();
            PGenericPair<Query, String> ret = new PGenericPair<Query, String>(query, fieldName);
            item.queries.add(ret);
            this.data.add(item);
            return ret;
        }
    }

    private static class TokenizedData {
        String value;
        Containers.IntList langGroups = null;
        List<PGenericPair<Query, String>> queries = null;

        private TokenizedData() {
        }
    }
}

