/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.api.impl.FacetsRequestImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.exceptions.UserInputException;
import de.cadenas.catalogsearch.lucene.exceptions.VariableNotAllowedException;
import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import de.cadenas.catalogsearch.lucene.index.VirtualFacetMapper;
import de.cadenas.catalogsearch.lucene.queryparser.BooleanQueryBuilder;
import de.cadenas.catalogsearch.lucene.queryparser.QueryParser;
import de.cadenas.catalogsearch.lucene.queryparser.QueryWrapper;
import de.cadenas.catalogsearch.lucene.queryparser.TraceQuery;
import de.cadenas.catalogsearch.lucene.search.PartListQuery;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PGenericPair;
import de.cadenas.util.PLogger;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;

public class QueryFactory {
    private static final PLogger logger = new PLogger(QueryFactory.class.getSimpleName());

    private static boolean addPathFilters(ISearchRequest req, BooleanQuery.Builder baseQuery, boolean forErp) {
        boolean hasPrjFilter = false;
        List<ISearchRequest.PathFilter> pathFilters = req.getPathFilters();
        if (pathFilters != null && !pathFilters.isEmpty()) {
            Query catPathQuery;
            List<String> excludeList;
            List<PGenericPair<String, String>> pathList;
            BooleanQueryBuilder bq = new BooleanQueryBuilder(BooleanClause.Occur.SHOULD);
            ISearchRequest.PathFilter pathFilter = pathFilters.size() > 1 && forErp ? pathFilters.get(1) : pathFilters.get(0);
            List<String> treeList = pathFilter.getTreeList();
            if (treeList != null) {
                ArrayList<BytesRef> pathNames = new ArrayList<BytesRef>();
                treeList.forEach(p -> pathNames.add(new BytesRef((CharSequence)p)));
                TermInSetQuery setQuery = new TermInSetQuery("treepath", pathNames);
                bq.add(setQuery);
            }
            if ((pathList = pathFilter.getPathList()) != null) {
                hasPrjFilter = true;
                ArrayList<BytesRef> pathNames = new ArrayList<BytesRef>();
                pathList.forEach(p -> pathNames.add(new BytesRef((String)p.first + "/" + (String)p.second)));
                TermInSetQuery setQuery = new TermInSetQuery("path", pathNames);
                bq.add(setQuery);
            }
            if ((excludeList = pathFilter.getExcludeList()) != null) {
                excludeList.forEach(p -> bq.add((Query)new TermQuery(new Term("path", (String)p)), true));
            }
            if ((catPathQuery = bq.build()) != null) {
                baseQuery.add(catPathQuery, BooleanClause.Occur.FILTER);
            }
        }
        return hasPrjFilter;
    }

    private static void splitAndProcess(String text, char sep, Consumer<String> handler) {
        int bgn = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != sep) continue;
            if (i > bgn) {
                handler.accept(text.substring(bgn, i));
            }
            bgn = i + 1;
        }
        if (text.length() > bgn) {
            if (bgn == 0) {
                handler.accept(text);
            } else {
                handler.accept(text.substring(bgn, text.length()));
            }
        }
    }

    public static DrillDownQueryContainer createDrillDownQuery(ISearchRequest req, Query baseQuery, boolean createFilterQuery) throws VariableNotAllowedException {
        DrillDownQuery ddq = null;
        Query modifiedBase = baseQuery;
        Map<String, Query> specialNumericQueries = null;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(modifiedBase, BooleanClause.Occur.MUST);
        String groupName = req.getErpGroupName();
        if (req.getTermFilters() != null && !req.getTermFilters().isEmpty()) {
            HashMap<String, List> andConjunctions = new HashMap<String, List>();
            ArrayList<PGenericPair<String, CallSite>> ddQueries = new ArrayList<PGenericPair<String, CallSite>>();
            for (ISearchRequest.TermFilter termFilter : req.getTermFilters()) {
                String dimName2;
                if (termFilter.getDim().equals("facet_categories")) {
                    String dimName22 = termFilter.getDim();
                } else {
                    dimName2 = "facet_" + termFilter.getDim();
                }
                if (groupName != null && termFilter.getDim().startsWith("erp_")) {
                    String varName = FieldDefinitions.getVarNameFromErpFacet(dimName2);
                    if (ErpConfiguration.getInstance().isErpVariable(varName) && !ErpConfiguration.getInstance().isVariableVisible(varName, groupName)) {
                        throw new VariableNotAllowedException(varName);
                    }
                }
                if (termFilter.useAndConjunction()) {
                    List valueList2 = andConjunctions.computeIfAbsent(dimName2, k -> new ArrayList());
                    valueList2.add(termFilter.getValue());
                    continue;
                }
                if (dimName2.equals("facet_categories")) {
                    List<String> classIdList = VirtualFacetMapper.getInstance().getClassIdsByVirtualId(termFilter.getValue());
                    if (classIdList == null) continue;
                    for (String classId : classIdList) {
                        ddQueries.add(new PGenericPair<String, CallSite>("facet_cls_eclass", (CallSite)((Object)("*:" + classId + "*"))));
                    }
                    continue;
                }
                QueryFactory.splitAndProcess(termFilter.getValue(), '\n', x -> ddQueries.add(new PGenericPair<String, String>(dimName2, (String)x)));
            }
            if (!andConjunctions.isEmpty()) {
                andConjunctions.forEach((dimName, valueList) -> {
                    String indexedField = FieldDefinitions.getFacetsConfig().getDimConfig((String)dimName).indexFieldName;
                    for (String value : valueList) {
                        if (value.contains("\n")) {
                            BooleanQuery.Builder subBuilder = new BooleanQuery.Builder();
                            QueryFactory.splitAndProcess(value, '\n', x -> subBuilder.add(new TermQuery(DrillDownQuery.term(indexedField, dimName, x)), BooleanClause.Occur.SHOULD));
                            builder.add(subBuilder.build(), BooleanClause.Occur.MUST);
                            continue;
                        }
                        Term term = DrillDownQuery.term(indexedField, dimName, value);
                        builder.add(new TermQuery(term), BooleanClause.Occur.MUST);
                    }
                });
                if (!createFilterQuery) {
                    modifiedBase = builder.build();
                }
            }
            if (!ddQueries.isEmpty()) {
                ddq = new DrillDownQuery(FieldDefinitions.getFacetsConfig(), modifiedBase);
                for (PGenericPair pGenericPair : ddQueries) {
                    if (((String)pGenericPair.second).contains("*")) {
                        FacetsConfig config = FieldDefinitions.getFacetsConfig();
                        String indexedField = config.getDimConfig((String)((String)pGenericPair.first)).indexFieldName;
                        Term term = DrillDownQuery.term(indexedField, (String)pGenericPair.first, (String)pGenericPair.second);
                        ddq.add("facet_categories", new WildcardQuery(term));
                        continue;
                    }
                    ddq.add((String)pGenericPair.first, (String)pGenericPair.second);
                }
            }
        }
        if (req.getRangeFilters() != null && !req.getRangeFilters().isEmpty()) {
            HashMap<String, MinMaxRange> minMaxRanges = new HashMap<String, MinMaxRange>();
            HashSet<String> hasSingleValueRangeFilter = new HashSet<String>();
            for (ISearchRequest.RangeFilter rangeFilter : req.getRangeFilters()) {
                String filterDim = rangeFilter.getDim().toLowerCase();
                double low = rangeFilter.getLow();
                double high = rangeFilter.getHigh();
                boolean isSingleValueRange = Math.abs(high - low) < 1.0E-5;
                if (!isSingleValueRange) continue;
                hasSingleValueRangeFilter.add(filterDim);
            }
            for (ISearchRequest.RangeFilter rangeFilter : req.getRangeFilters()) {
                int pq;
                String filterDim;
                double low = rangeFilter.getLow();
                double high = rangeFilter.getHigh();
                Query subQuery = null;
                String varName = filterDim = rangeFilter.getDim().toLowerCase();
                int physicalQuantity = 0;
                int sepIndex = varName.indexOf(64);
                if (sepIndex != -1) {
                    String subStr = varName.substring(sepIndex + 1);
                    pq = NumUtils.getInteger(subStr);
                    if (pq != Integer.MIN_VALUE) {
                        physicalQuantity = pq;
                    }
                    varName = varName.substring(0, sepIndex);
                }
                if (groupName != null && ErpConfiguration.getInstance().isErpVariable(varName) && !ErpConfiguration.getInstance().isVariableVisible(varName, groupName)) {
                    throw new VariableNotAllowedException(varName);
                }
                String searchFieldName = "col_number_" + varName;
                pq = physicalQuantity;
                MinMaxRange range = minMaxRanges.computeIfAbsent(filterDim, k -> new MinMaxRange(searchFieldName, pq));
                ++range.count;
                range.min = Math.min(range.min, low);
                range.max = Math.max(range.max, high);
                if (!(Math.abs(low - high) < 1.0E-5) && hasSingleValueRangeFilter.contains(filterDim)) continue;
                if (!Double.isNaN(low) && !Double.isNaN(high)) {
                    subQuery = ValueRangeQuery.newIntersectsQuery(searchFieldName, low, high, true, physicalQuantity);
                } else if (!Double.isNaN(low)) {
                    subQuery = ValueRangeQuery.newIntersectsQuery(searchFieldName, low, Double.POSITIVE_INFINITY, true, physicalQuantity);
                } else if (!Double.isNaN(high)) {
                    subQuery = ValueRangeQuery.newIntersectsQuery(searchFieldName, Double.NEGATIVE_INFINITY, high, true, physicalQuantity);
                }
                if (subQuery == null) continue;
                String dimName3 = "facet_var_" + filterDim;
                if (ddq == null) {
                    ddq = new DrillDownQuery(FieldDefinitions.getFacetsConfig(), modifiedBase);
                }
                ddq.add(dimName3, subQuery);
            }
            specialNumericQueries = QueryFactory.getSpecialNumericQueries(ddq, modifiedBase, minMaxRanges);
        }
        if (createFilterQuery) {
            if (ddq != null) {
                builder.add(ddq, BooleanClause.Occur.MUST);
            }
            modifiedBase = builder.build();
            ddq = null;
        }
        DrillDownQueryContainer result = new DrillDownQueryContainer();
        result.modifiedBaseQuery = modifiedBase;
        result.ddq = ddq;
        result.specialNumericQueries = specialNumericQueries;
        return result;
    }

    private static Map<String, Query> getSpecialNumericQueries(DrillDownQuery ddq, Query modifiedBase, Map<String, MinMaxRange> minMaxRanges) {
        HashMap<CallSite, BooleanQuery> specialNumericQueries = null;
        if (ddq != null && !minMaxRanges.isEmpty()) {
            try {
                Field drillDownDimsField = ddq.getClass().getDeclaredField("drillDownDims");
                drillDownDimsField.setAccessible(true);
                Map drillDownDims = (Map)drillDownDimsField.get(ddq);
                Field dimQueriesField = ddq.getClass().getDeclaredField("dimQueries");
                dimQueriesField.setAccessible(true);
                List dimQueries = (List)dimQueriesField.get(ddq);
                for (Map.Entry<String, MinMaxRange> rangeEntry : minMaxRanges.entrySet()) {
                    MinMaxRange range = rangeEntry.getValue();
                    if (range.count <= 1) continue;
                    String filterName = "facet_var_" + rangeEntry.getKey();
                    BooleanQuery.Builder specialBuilder = new BooleanQuery.Builder();
                    specialBuilder.add(modifiedBase, BooleanClause.Occur.MUST);
                    Query rangeQuery = ValueRangeQuery.newIntersectsQuery(range.searchField, range.min, range.max, true, range.physicalQuantity);
                    specialBuilder.add(rangeQuery, BooleanClause.Occur.FILTER);
                    for (Map.Entry item : drillDownDims.entrySet()) {
                        if (((String)item.getKey()).equals(filterName)) continue;
                        BooleanQuery.Builder builder = (BooleanQuery.Builder)dimQueries.get((Integer)item.getValue());
                        specialBuilder.add(builder.build(), BooleanClause.Occur.FILTER);
                    }
                    if (specialNumericQueries == null) {
                        specialNumericQueries = new HashMap<CallSite, BooleanQuery>();
                    }
                    specialNumericQueries.put((CallSite)((Object)filterName), specialBuilder.build());
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        return specialNumericQueries;
    }

    public static Query createQuery(String searchQuery, List<String> langList, String erpGroup, boolean searchDocuments) throws UserInputException {
        if (searchQuery.trim().compareTo("*") == 0) {
            return new DocValuesFieldExistsQuery("$facets");
        }
        QueryParser qparser = new QueryParser(new FieldAwareAnalyzer(false));
        qparser.setSearchDocuments(searchDocuments);
        return qparser.parse(searchQuery, langList, erpGroup);
    }

    public static Query createQuery(ISearchRequest req, String erpGroup) throws UserInputException {
        ErpConfiguration erpConfig;
        Query fq;
        BooleanQuery.Builder baseQuery = new BooleanQuery.Builder();
        if (req.getQuery() != null && !req.getQuery().isEmpty()) {
            Query q = QueryFactory.createQuery(req.getQuery(), req.getLanguageList(), erpGroup, req.searchDocuments());
            if (q == null) {
                return null;
            }
            baseQuery.add(q, BooleanClause.Occur.MUST);
        } else {
            Map<String, List<FacetsRequestImpl.PartId>> partFilter = req.getPartFilter();
            if (partFilter != null) {
                PartListQuery q = new PartListQuery(ServiceFactory.getIndexManager(), partFilter);
                baseQuery.add(q, BooleanClause.Occur.MUST);
            }
        }
        if (erpGroup != null && req.getErpFilterQuery() != null && !req.getErpFilterQuery().isEmpty() && (fq = QueryFactory.createQuery(req.getErpFilterQuery(), req.getLanguageList(), null, false)) != null) {
            baseQuery.add(fq, BooleanClause.Occur.FILTER);
        }
        boolean hasPrjFilter = QueryFactory.addPathFilters(req, baseQuery, erpGroup != null && !erpGroup.isEmpty());
        if (erpGroup != null && !erpGroup.isEmpty() && (erpConfig = ErpConfiguration.getInstance()).isValid()) {
            String fieldName = erpGroup + "_erp_flag";
            TermQuery tq = new TermQuery(new Term(fieldName, "visible"));
            baseQuery.add(tq, BooleanClause.Occur.FILTER);
            if (req.isErpPreferredLine()) {
                fieldName = erpGroup + "_erp_flag";
                tq = new TermQuery(new Term(fieldName, "preferred"));
                baseQuery.add(tq, BooleanClause.Occur.FILTER);
            }
        }
        if (hasPrjFilter) {
            BooleanQuery.Builder typeQuery = new BooleanQuery.Builder();
            TermQuery tq = new TermQuery(new Term("type", "psol-row"));
            typeQuery.add(tq, BooleanClause.Occur.SHOULD);
            TermQuery th = new TermQuery(new Term("type", "psol-hidden-row"));
            typeQuery.add(th, BooleanClause.Occur.SHOULD);
            baseQuery.add(typeQuery.build(), BooleanClause.Occur.FILTER);
        } else {
            TermQuery tq = new TermQuery(new Term("type", "psol-row"));
            baseQuery.add(tq, BooleanClause.Occur.FILTER);
        }
        List<ISearchRequest.LicenseRange> licenseRange = req.getLicenseRange();
        for (ISearchRequest.LicenseRange licRange : licenseRange) {
            BooleanQuery.Builder licQueryBuilder = new BooleanQuery.Builder();
            Query licQueryLow = IntPoint.newRangeQuery("lic_low", Integer.MIN_VALUE, licRange.getUpper());
            Query licQueryUp = IntPoint.newRangeQuery("lic_up", licRange.getLower(), Integer.MAX_VALUE);
            licQueryBuilder.add(licQueryLow, BooleanClause.Occur.FILTER);
            licQueryBuilder.add(licQueryUp, BooleanClause.Occur.FILTER);
            QueryWrapper licQuery = new QueryWrapper(licQueryBuilder.build()){

                @Override
                public boolean isDisabled(LeafReaderContext leafReaderContext) {
                    return leafReaderContext.reader().getFieldInfos().fieldInfo("lic_low") == null;
                }
            };
            baseQuery.add(licQuery, BooleanClause.Occur.FILTER);
        }
        Query query = baseQuery.build();
        if (logger.traceEnabled()) {
            query = new TraceQuery(query);
        }
        return query;
    }

    private static class MinMaxRange {
        String searchField;
        int physicalQuantity;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int count = 0;

        public MinMaxRange(String searchField, int pq) {
            this.searchField = searchField;
            this.physicalQuantity = pq;
        }
    }

    public static class DrillDownQueryContainer {
        public Query modifiedBaseQuery = null;
        public DrillDownQuery ddq = null;
        public Map<String, Query> specialNumericQueries = null;
    }
}

