/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.impl.FacetsRequestImpl;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class PartListQuery
extends Query {
    private final Map<String, List<FacetsRequestImpl.PartId>> parts;
    private final Map<IndexReader, IntList> docIDs = new HashMap<IndexReader, IntList>();
    private final IIndexManager indexManager;

    public PartListQuery(IIndexManager indexManager, Map<String, List<FacetsRequestImpl.PartId>> parts) {
        this.indexManager = indexManager;
        this.parts = parts;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Scorer scorer(LeafReaderContext context) {
                IntList docIdList = null;
                Map<IndexReader, IntList> map = PartListQuery.this.docIDs;
                synchronized (map) {
                    docIdList = PartListQuery.this.docIDs.get(context.parent.reader());
                }
                if (docIdList == null) {
                    docIdList = new IntArrayList();
                    IIndexManager.IIndexReaderData readerData = PartListQuery.this.indexManager.findReaderData(context.parent.reader());
                    if (readerData != null) {
                        List<FacetsRequestImpl.PartId> partList = null;
                        for (String catName : readerData.getUsedCatalogNames()) {
                            partList = PartListQuery.this.parts.get(catName);
                            if (partList == null) continue;
                            IDocIdIndex docIdIndex = readerData.getDocIdIndex();
                            for (FacetsRequestImpl.PartId partId : partList) {
                                docIdIndex.collectDocIds(partId.classId, partId.lineId, partId.lineSubId, docIdList, true);
                            }
                        }
                        Map<IndexReader, IntList> map2 = PartListQuery.this.docIDs;
                        synchronized (map2) {
                            PartListQuery.this.docIDs.put(context.parent.reader(), docIdList);
                        }
                    }
                }
                IntArrayList leafIdList = new IntArrayList();
                int rangeBegin = context.docBaseInParent;
                int l = context.ordInParent;
                List<IndexReaderContext> leaves = context.parent.children();
                int rangeEnd = l < leaves.size() - 1 ? leaves.get((int)(l + 1)).docBaseInParent : Integer.MAX_VALUE;
                Iterator<Integer> iterator = docIdList.iterator();
                while (iterator.hasNext()) {
                    int doc = (Integer)iterator.next();
                    if (doc < rangeBegin || doc >= rangeEnd) continue;
                    leafIdList.add(doc - rangeBegin);
                }
                IntListIterator iterator2 = new IntListIterator(leafIdList);
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator2);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.parts.equals(((PartListQuery)other).parts);
    }

    @Override
    public int hashCode() {
        return 31 * this.parts.hashCode();
    }

    @Override
    public String toString(String field) {
        return "IntListIterator";
    }

    private static class IntListIterator
    extends DocIdSetIterator {
        private final IntList docIds;
        private int index = -1;

        public IntListIterator(IntList docIds) {
            this.docIds = docIds;
            this.docIds.sort((IntComparator)null);
        }

        @Override
        public int advance(int target) {
            if (target == Integer.MAX_VALUE) {
                this.index = this.docIds.size();
                return Integer.MAX_VALUE;
            }
            if (this.index == -1) {
                this.index = 0;
            }
            while (this.index < this.docIds.size() && this.docIds.getInt(this.index) < target) {
                ++this.index;
            }
            if (this.index < this.docIds.size() && this.docIds.getInt(this.index) >= target) {
                return this.docIds.getInt(this.index);
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int docID() {
            if (this.index >= 0 && this.index < this.docIds.size()) {
                return this.docIds.getInt(this.index);
            }
            if (this.index >= this.docIds.size()) {
                return Integer.MAX_VALUE;
            }
            return -1;
        }

        @Override
        public int nextDoc() {
            ++this.index;
            return this.docID();
        }

        @Override
        public long cost() {
            return 0L;
        }
    }
}

