/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.lucene.facet.FacetStateProvider;
import de.cadenas.catalogsearch.lucene.facet.IFacetListBuilder;
import de.cadenas.catalogsearch.lucene.facet.PFacetCounts;
import de.cadenas.catalogsearch.lucene.facet.PSolMultiFacets;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.search.IndexSearcher;

public class PSolDrillSideways
extends DrillSideways {
    private final ExecutorService executorService;
    private final FacetCountingFilter facetFilter;
    private final FacetStateProvider facetProvider;
    private final boolean optimizedFacetCounter;
    private Map<String, List<FacetsCollector.MatchingDocs>> numericSidewaysDocs = null;
    private FacetListBuilder facetListBuilder = null;

    public IFacetListBuilder getFacetListBuilder() {
        return this.facetListBuilder;
    }

    public PSolDrillSideways(IndexSearcher searcher, FacetsConfig config, FacetStateProvider facetProvider, FacetCountingFilter facetFilter, ExecutorService executor, boolean optimizedFacetCounter) throws IOException {
        super(searcher, config, null, facetProvider.getCommonState(), executor);
        this.executorService = executor;
        this.facetFilter = facetFilter;
        this.facetProvider = facetProvider;
        this.optimizedFacetCounter = optimizedFacetCounter;
    }

    public void addNumericSidewaysDocs(String dim, List<FacetsCollector.MatchingDocs> docs) {
        if (this.numericSidewaysDocs == null) {
            this.numericSidewaysDocs = new HashMap<String, List<FacetsCollector.MatchingDocs>>();
        }
        this.numericSidewaysDocs.put(dim, docs);
    }

    @Override
    protected Facets buildFacetsResult(FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims) {
        for (int i = 0; i < drillSideways.length; ++i) {
            this.facetFilter.setupFilter(drillSidewaysDims[i], drillSideways[i].getMatchingDocs());
        }
        if (this.state != null) {
            this.facetListBuilder = new FacetListBuilder(this.facetProvider, this.optimizedFacetCounter, this.state, this.facetFilter, this.executorService, drillDowns, drillSideways, drillSidewaysDims, this.numericSidewaysDocs);
        }
        return null;
    }

    private static class FacetListBuilder
    implements IFacetListBuilder {
        private final FacetStateProvider facetProvider;
        private final boolean optimizedFacetCounter;
        private final SortedSetDocValuesReaderState state;
        private final FacetCountingFilter facetFilter;
        private final ExecutorService executorService;
        private final FacetsCollector drillDowns;
        private final FacetsCollector[] drillSideways;
        private final String[] drillSidewaysDims;
        private final Map<String, List<FacetsCollector.MatchingDocs>> numericSidewaysDocs;

        private boolean hasMatches(FacetsCollector collector) {
            for (FacetsCollector.MatchingDocs md : collector.getMatchingDocs()) {
                if (md.totalHits <= 0) continue;
                return true;
            }
            return false;
        }

        public FacetListBuilder(FacetStateProvider facetProvider, boolean optimizedFacetCounter, SortedSetDocValuesReaderState state, FacetCountingFilter facetFilter, ExecutorService executorService, FacetsCollector drillDowns, FacetsCollector[] drillSideways, String[] drillSidewaysDims, Map<String, List<FacetsCollector.MatchingDocs>> numericSidewaysDocs) {
            this.facetProvider = facetProvider;
            this.optimizedFacetCounter = optimizedFacetCounter;
            this.state = state;
            this.facetFilter = facetFilter;
            this.executorService = executorService;
            this.drillDowns = drillDowns;
            this.drillSideways = drillSideways;
            this.drillSidewaysDims = drillSidewaysDims;
            this.numericSidewaysDocs = numericSidewaysDocs;
        }

        @Override
        public IFacetListBuilder.Result buildResults(boolean loadVariableFacets, boolean loadFilterFacets) {
            IFacetListBuilder.Result result = new IFacetListBuilder.Result();
            PFacetCounts drillDownFacets = null;
            PFacetCounts drillDownVarFacets = null;
            PFacetCounts filterAssistantFacets = null;
            SortedSetDocValuesReaderState filterState = null;
            HashMap<String, Facets> drillSidewaysFacets = new HashMap<String, Facets>();
            boolean hasMatches = this.hasMatches(this.drillDowns);
            try {
                FacetStateProvider.StateObject varState = null;
                if (loadVariableFacets && hasMatches) {
                    varState = this.facetProvider.getVariableState(this.drillDowns.getMatchingDocs());
                }
                if (loadFilterFacets && hasMatches) {
                    filterState = this.facetProvider.getFilterAssistantState();
                }
                boolean optimized = this.optimizedFacetCounter;
                try {
                    if (hasMatches) {
                        drillDownFacets = new PFacetCounts(this.state, this.drillDowns.getMatchingDocs(), this.facetFilter, optimized, null, this.executorService);
                        if (varState != null) {
                            drillDownVarFacets = new PFacetCounts(varState.state(), varState.docs(), this.facetFilter, false, null, this.executorService);
                        }
                        if (filterState != null) {
                            filterAssistantFacets = new PFacetCounts(filterState, this.drillDowns.getMatchingDocs(), this.facetFilter, false, null, this.executorService);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.drillSideways != null) {
                    HashMap<String, IFacetListBuilder.Result.NumericSideway> numericSideways = new HashMap<String, IFacetListBuilder.Result.NumericSideway>();
                    for (int i = 0; i < this.drillSideways.length; ++i) {
                        if (!this.hasMatches(this.drillSideways[i])) continue;
                        String dimName = this.drillSidewaysDims[i];
                        if (dimName.startsWith("facet_var_")) {
                            IFacetListBuilder.Result.NumericSideway ns = new IFacetListBuilder.Result.NumericSideway();
                            ns.sidewaysDocs = this.drillSideways[i].getMatchingDocs();
                            if (this.numericSidewaysDocs != null) {
                                ns.specialNumericDocs = this.numericSidewaysDocs.get(dimName);
                            }
                            numericSideways.put(dimName, ns);
                            continue;
                        }
                        if (dimName.startsWith("facet_text_") && dimName.startsWith("facet_text_f:")) {
                            try {
                                if (filterState == null) continue;
                                drillSidewaysFacets.put(dimName, new PFacetCounts(filterState, this.drillSideways[i].getMatchingDocs(), this.facetFilter, false, dimName, this.executorService));
                            }
                            catch (InterruptedException ns) {}
                            continue;
                        }
                        if (dimName.startsWith("facet_text_") && !dimName.startsWith("facet_text_c:")) {
                            try {
                                varState = null;
                                if (loadVariableFacets) {
                                    varState = this.facetProvider.getVariableState(this.drillSideways[i].getMatchingDocs());
                                }
                                if (varState == null) continue;
                                drillSidewaysFacets.put(dimName, new PFacetCounts(varState.state(), varState.docs(), this.facetFilter, false, dimName, this.executorService));
                            }
                            catch (InterruptedException ns) {}
                            continue;
                        }
                        PFacetCounts sideFacets = null;
                        try {
                            sideFacets = new PFacetCounts(this.state, this.drillSideways[i].getMatchingDocs(), this.facetFilter, optimized, dimName, this.executorService);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (sideFacets == null) continue;
                        drillSidewaysFacets.put(dimName, sideFacets);
                    }
                    result.numericSideways = numericSideways;
                }
                if (drillSidewaysFacets.isEmpty() && drillDownVarFacets == null && filterAssistantFacets == null && drillDownFacets != null) {
                    List<FacetResult> facetResults = ((Facets)drillDownFacets).getAllDims(10000);
                    result.facetResults.add(facetResults);
                } else {
                    PSolMultiFacets facets = new PSolMultiFacets(drillSidewaysFacets, drillDownFacets, drillDownVarFacets, filterAssistantFacets);
                    List<FacetResult> facetResults = facets.getAllDims(10000);
                    result.facetResults.add(facetResults);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }
}

