/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.search.PSolTopScoreDocCollector;
import de.cadenas.util.Containers;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.search.DocIdSetIterator;

public class FacetCountingFilter {
    private final IIndexManager indexManager;
    private final Map<String, Map<String, List<FacetsCollector.MatchingDocs>>> docsByCatalog = new HashMap<String, Map<String, List<FacetsCollector.MatchingDocs>>>();
    private boolean filterMode = false;

    private IntSet createFilter(IIndexManager.IIndexReaderData readerData, String dim) throws IOException {
        IIndexManager.IIndexReaderData sourceReaderData;
        Map<String, List<FacetsCollector.MatchingDocs>> map;
        IDocIdIndex sourceDocIdIndex = null;
        List<FacetsCollector.MatchingDocs> sourceDocs = null;
        IDocIdIndex docIdIndex = readerData.getDocIdIndex();
        if (this.filterMode && (map = this.docsByCatalog.get(readerData.getCatalogName())) != null && (sourceDocs = map.get(dim)) != null && sourceDocs.size() > 0 && (sourceReaderData = this.indexManager.findReaderData(sourceDocs.get((int)0).context.parent.reader())) != null) {
            sourceDocIdIndex = sourceReaderData.getDocIdIndex();
        }
        if (sourceDocIdIndex != null) {
            IntOpenHashSet filter = new IntOpenHashSet();
            HashMap<String, IntSet> idsByProject = new HashMap<String, IntSet>();
            for (FacetsCollector.MatchingDocs sourceDoc : sourceDocs) {
                DocIdSetIterator it = sourceDoc.bits.iterator();
                int docId = it.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    IDocIdIndex.PrjIdentifier identifier = sourceDocIdIndex.findByDocId(docId + sourceDoc.context.docBaseInParent);
                    if (identifier != null) {
                        idsByProject.computeIfAbsent(identifier.path, path -> new IntOpenHashSet()).add(identifier.lineId);
                    }
                    docId = it.nextDoc();
                }
            }
            docIdIndex.collectDocIds(idsByProject, (IntSet)filter);
            return filter;
        }
        return null;
    }

    public FacetCountingFilter(IIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setFilterMode(boolean filter) {
        this.filterMode = filter;
    }

    public boolean getFilterMode() {
        return this.filterMode;
    }

    public void setupFilter(PSolTopScoreDocCollector fc) {
        this.setupFilter(null, fc.getMatchingDocs());
    }

    public void setupFilter(String dim, List<FacetsCollector.MatchingDocs> matchingDocs) {
        if (this.filterMode) {
            return;
        }
        for (FacetsCollector.MatchingDocs matchingDoc : matchingDocs) {
            CompositeReader reader;
            IIndexManager.IIndexReaderData sourceReaderData;
            if (matchingDoc.totalHits == 0 || (sourceReaderData = this.indexManager.findReaderData(reader = matchingDoc.context.parent.reader())) == null) continue;
            Map map = this.docsByCatalog.computeIfAbsent(sourceReaderData.getCatalogName(), k -> new HashMap());
            List list = map.computeIfAbsent(dim, k -> new ArrayList());
            list.add(matchingDoc);
        }
    }

    public Containers.IntList getFilteredDocIds(IIndexManager.IIndexReaderData readerData, FacetsCollector.MatchingDocs hits, String dim, int baseDocId) throws IOException {
        Containers.IntList docIdList = new Containers.IntList();
        IntSet filter = this.createFilter(readerData, dim);
        DocIdSetIterator it = hits.bits.iterator();
        int docId = it.nextDoc();
        if (filter == null || filter.isEmpty()) {
            while (docId != Integer.MAX_VALUE) {
                docIdList.add(docId + baseDocId);
                docId = it.nextDoc();
            }
        } else {
            int checkBaseId = hits.context.docBaseInParent;
            while (docId != Integer.MAX_VALUE) {
                if (!filter.contains(docId + checkBaseId)) {
                    docIdList.add(docId + baseDocId);
                }
                docId = it.nextDoc();
            }
        }
        return docIdList;
    }

    public int countFilteredDocIds(IIndexManager.IIndexReaderData readerData, FacetsCollector.MatchingDocs hits, String dim) throws IOException {
        IntSet filter = this.createFilter(readerData, dim);
        if (filter == null || filter.isEmpty()) {
            return hits.totalHits;
        }
        DocIdSetIterator it = hits.bits.iterator();
        int docId = it.nextDoc();
        int count = 0;
        int baseDocId = hits.context.docBaseInParent;
        while (docId != Integer.MAX_VALUE) {
            if (!filter.contains(docId + baseDocId)) {
                ++count;
            }
            docId = it.nextDoc();
        }
        return count;
    }

    public IntSet createDocIdFilter(IIndexManager.IIndexReaderData readerData, String dim) throws IOException {
        return this.createFilter(readerData, dim);
    }
}

