/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ISearchServiceApi;
import de.cadenas.catalogsearch.api.ServiceFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class CountingCollectorManager
implements CollectorManager<CountingCollector, ISearchServiceApi.CountingResult> {
    @Override
    public CountingCollector newCollector() {
        return new CountingCollector();
    }

    @Override
    public ISearchServiceApi.CountingResult reduce(Collection<CountingCollector> collectors) throws IOException {
        int totalHitCount = 0;
        HashSet<String> usedCatalogs = new HashSet<String>();
        if (collectors != null) {
            for (CountingCollector collector : collectors) {
                totalHitCount += collector.getHitCount();
                usedCatalogs.addAll(collector.getUsedCatalogs());
            }
        }
        return new ISearchServiceApi.CountingResult(totalHitCount, usedCatalogs);
    }

    static class CountingCollector
    implements Collector,
    LeafCollector {
        private int hitCount = 0;
        private final Set<String> usedCatalogs = new HashSet<String>();
        private Set<String> currentlyUsedCatalogs = null;
        private final IIndexManager indexManager = ServiceFactory.getIndexManager();
        private int lastHitCount = 0;

        CountingCollector() {
        }

        public int getHitCount() {
            return this.hitCount;
        }

        public Set<String> getUsedCatalogs() {
            if (this.currentlyUsedCatalogs != null) {
                if (this.hitCount - this.lastHitCount > 0) {
                    this.usedCatalogs.addAll(this.currentlyUsedCatalogs);
                }
                this.currentlyUsedCatalogs = null;
            }
            return this.usedCatalogs;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) {
            if (this.currentlyUsedCatalogs != null) {
                if (this.hitCount - this.lastHitCount > 0) {
                    this.usedCatalogs.addAll(this.currentlyUsedCatalogs);
                }
                this.currentlyUsedCatalogs = null;
            }
            this.lastHitCount = this.hitCount;
            CompositeReader reader = context.parent.reader();
            IIndexManager.IIndexReaderData indexContainer = this.indexManager.findReaderData(reader);
            if (indexContainer != null) {
                this.usedCatalogs.addAll(indexContainer.getUsedCatalogNames());
            }
            return this;
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }

        @Override
        public void setScorer(Scorable scorer) {
        }

        @Override
        public void collect(int doc) {
            ++this.hitCount;
        }
    }
}

