/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.related;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RelatedWordsRequest {
    public String query;
    public List<String> catalogList = null;
    public List<String> languageList = null;
    public int maxResults = 10;

    public static RelatedWordsRequest fromJson(JSONObject obj) {
        RelatedWordsRequest request = new RelatedWordsRequest();
        request.query = obj.getString("word");
        request.maxResults = obj.getInt("maxResults");
        request.languageList = new ArrayList<String>();
        JSONArray jLangList = obj.optJSONArray("languages");
        if (jLangList != null) {
            for (int i = 0; i < jLangList.length(); ++i) {
                String lang = jLangList.getString(i);
                if (request.languageList.contains(lang)) continue;
                request.languageList.add(lang);
            }
        }
        request.catalogList = new ArrayList<String>();
        JSONArray jCatalogList = obj.optJSONArray("catalogs");
        if (jCatalogList != null) {
            for (int i = 0; i < jCatalogList.length(); ++i) {
                String catname = jCatalogList.getString(i);
                if (request.catalogList.contains(catname)) continue;
                request.catalogList.add(catname);
            }
        }
        return request;
    }
}

