/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.related;

import org.apache.lucene.index.IndexWriterConfig;
import org.json.JSONObject;

public class OpenRelatedIndexRequest {
    public String catalogName;
    public String indexPath;
    public IndexWriterConfig.OpenMode openMode = IndexWriterConfig.OpenMode.CREATE;

    public static OpenRelatedIndexRequest fromJson(JSONObject json) {
        OpenRelatedIndexRequest request = new OpenRelatedIndexRequest();
        request.catalogName = json.getString("catalog");
        request.indexPath = json.optString("indexPath");
        String openMode = json.optString("openMode");
        if (openMode != null && !openMode.isEmpty()) {
            if (openMode.equals("create")) {
                request.openMode = IndexWriterConfig.OpenMode.CREATE;
            } else if (openMode.equals("append")) {
                request.openMode = IndexWriterConfig.OpenMode.APPEND;
            } else if (openMode.equals("create_or_append")) {
                request.openMode = IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
            }
        }
        return request;
    }
}

