/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolExplain;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumWrapper
extends PostingsEnumBase {
    private final Scorer scorer;
    private final DocIdSetIterator iter;
    private final PSolExplain explain;

    PostingsEnumWrapper(Scorer scorer, PSolExplain explain) {
        this.scorer = scorer;
        this.iter = scorer.iterator();
        this.explain = explain;
    }

    @Override
    public int docID() {
        return this.iter.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.iter.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.iter.advance(target);
    }

    @Override
    public long cost() {
        return this.iter.cost();
    }

    @Override
    public int freq() {
        return 1;
    }

    @Override
    public int nextPosition() {
        return 0;
    }

    @Override
    public int startOffset() {
        return -1;
    }

    @Override
    public int endOffset() {
        return -1;
    }

    @Override
    public BytesRef getPayload() {
        return null;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        try {
            return this.explain.explain(context, doc);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public float getBoost() {
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            return 1.0f;
        }
    }
}

