/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumPhrase;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;

public class PostingsEnumPhraseStandard
extends PostingsEnumPhrase {
    PostingsEnumPhraseStandard(List<Item> list, ContextCache contextCache, String searchField, boolean isStrict) {
        super(list, contextCache, searchField, isStrict);
        this.iterator = this.createApproximation(list);
    }

    private DocIdSetIterator createApproximation(List<Item> itemList) {
        if (itemList.size() == 1) {
            return itemList.get((int)0).postings;
        }
        ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
        for (Item item : itemList) {
            iterators.add(item.postings);
        }
        return ConjunctionUtils.intersectIterators(iterators);
    }

    @Override
    protected boolean advanceToNextPosition() throws IOException {
        block5: {
            Item lead = (Item)this.getItem(0);
            PostingsEnumPhrase.Item.State lstate = lead.nextPosition();
            if (lstate != PostingsEnumPhrase.Item.State.Found) {
                return false;
            }
            block0: while (true) {
                int phrasePos = lead.postPos;
                int icount = this.countItems();
                for (int j = 1; j < icount; ++j) {
                    int expectedPos;
                    Item item = (Item)this.getItem(j);
                    if (item.advancePosition(expectedPos = phrasePos + j) != PostingsEnumPhrase.Item.State.Finished) {
                        if (item.postPos == expectedPos) continue;
                        if (lead.advancePosition(phrasePos + 1) == PostingsEnumPhrase.Item.State.Found) {
                            continue block0;
                        }
                    }
                    break block5;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkPhraseMatchesStrictMode(int doc) {
        int firstPos = this.getItem(0).getMatchBgn();
        int lastPos = this.getItem(this.countItems() - 1).getMatchEnd();
        IntSet termsByDoc = this.getPositionsByDocId(doc);
        if (termsByDoc != null) {
            IntIterator intIterator = termsByDoc.iterator();
            while (intIterator.hasNext()) {
                int pos = (Integer)intIterator.next();
                if (pos == firstPos - 1) {
                    return false;
                }
                if (pos != lastPos + 1) continue;
                return false;
            }
        }
        return true;
    }

    public static class Item
    extends PostingsEnumPhrase.Item {
        public Item(PostingsEnum postings, Term term) {
            super(postings, term);
        }

        @Override
        public DocIdSetIterator createApproximation() {
            return this.postings;
        }

        @Override
        public void resetPosition(int docID) throws IOException {
            this.freqState = 0;
            this.postPos = -1;
        }

        @Override
        public PostingsEnumPhrase.Item.State nextPosition() throws IOException {
            if (this.freqState < this.postings.freq()) {
                this.postPos = this.postings.nextPosition();
                ++this.freqState;
                return PostingsEnumPhrase.Item.State.Found;
            }
            return PostingsEnumPhrase.Item.State.Finished;
        }

        @Override
        public PostingsEnumPhrase.Item.State advancePosition(int target) throws IOException {
            while (this.postPos < target) {
                if (this.freqState == this.postings.freq()) {
                    return PostingsEnumPhrase.Item.State.Finished;
                }
                this.postPos = this.postings.nextPosition();
                ++this.freqState;
            }
            return PostingsEnumPhrase.Item.State.Found;
        }

        @Override
        public int getMatchBgn() {
            return this.postPos;
        }

        @Override
        public int getMatchEnd() {
            return this.postPos;
        }
    }
}

