/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public abstract class PostingsEnumPhrase
extends PostingsEnumBase {
    protected final List<Item> postList;
    protected DocIdSetIterator iterator;
    private int doc;
    private int freq;
    private final boolean strictMode;
    private final ContextCache contextCache;
    private final String searchField;
    private Int2ObjectMap<IntSet> allTermPositions = null;
    private PositionState positionState = PositionState.noMorePositions;

    PostingsEnumPhrase(List<Item> list, ContextCache contextCache, String searchField, boolean isStrict) {
        this.postList = list;
        this.iterator = null;
        this.doc = -1;
        this.freq = 0;
        this.contextCache = contextCache;
        this.searchField = searchField;
        this.strictMode = isStrict;
    }

    int countItems() {
        return this.postList.size();
    }

    Item getItem(int index) {
        return this.postList.get(index);
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        do {
            this.doc = this.iterator.nextDoc();
            if (this.doc == Integer.MAX_VALUE) {
                this.positionState = PositionState.noMorePositions;
                return this.doc;
            }
            this.positionState = PositionState.uninitialized;
        } while (!this.calculateNextPosition());
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        while (true) {
            this.doc = this.iterator.advance(target);
            if (this.doc == Integer.MAX_VALUE) {
                this.positionState = PositionState.noMorePositions;
                return this.doc;
            }
            this.positionState = PositionState.uninitialized;
            if (this.calculateNextPosition()) {
                return this.doc;
            }
            target = this.doc + 1;
        }
    }

    @Override
    public long cost() {
        return this.iterator.cost();
    }

    @Override
    public int freq() throws IOException {
        this.calculateNextPosition();
        return this.freq;
    }

    @Override
    public int nextPosition() throws IOException {
        if (this.calculateNextPosition()) {
            this.positionState = PositionState.uncalced;
            return this.postList.get(0).getMatchBgn();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int startOffset() throws IOException {
        return this.postList.get((int)0).postings.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.postList.get((int)(this.postList.size() - 1)).postings.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.postList.get((int)0).postings.getPayload();
    }

    @Override
    public IntList getReferencedDocList() {
        if (!this.postList.isEmpty() && this.postList.get((int)0).postings instanceof PostingsEnumBase) {
            PostingsEnumBase pb = (PostingsEnumBase)this.postList.get((int)0).postings;
            return pb.getReferencedDocList();
        }
        return null;
    }

    @Override
    public int getPhraseEnd() {
        return this.postList.get(this.postList.size() - 1).getMatchEnd();
    }

    protected IntSet getPositionsByDocId(int id) {
        if (this.allTermPositions == null) {
            this.allTermPositions = new Int2ObjectOpenHashMap<IntSet>();
            if (!this.searchField.isEmpty()) {
                try {
                    TermsEnum te;
                    Terms terms = this.contextCache.getTerms(this.searchField);
                    if (terms != null && (te = terms.iterator()) != null) {
                        BytesRef br = te.next();
                        while (br != null) {
                            PostingsEnum pi = te.postings(null, 24);
                            int docId = pi.nextDoc();
                            while (docId != Integer.MAX_VALUE) {
                                IntSet posList = this.allTermPositions.computeIfAbsent(docId, k -> new IntOpenHashSet());
                                int freq = pi.freq();
                                while (freq-- > 0) {
                                    int pos = pi.nextPosition();
                                    posList.add(pos);
                                }
                                docId = pi.nextDoc();
                            }
                            br = te.next();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return (IntSet)this.allTermPositions.get(id);
    }

    private boolean calculateNextPosition() throws IOException {
        if (!this.calculateNextPhrasePosition()) {
            return false;
        }
        if (!this.strictMode) {
            return true;
        }
        return this.checkPhraseMatchesStrictMode(this.doc);
    }

    protected abstract boolean checkPhraseMatchesStrictMode(int var1);

    private boolean calculateNextPhrasePosition() throws IOException {
        if (this.positionState == PositionState.uninitialized) {
            this.resetPositions(this.doc);
            this.freq = 0;
            this.positionState = PositionState.uncalced;
        }
        if (this.positionState == PositionState.uncalced) {
            if (this.advanceToNextPosition()) {
                this.positionState = PositionState.calced;
                ++this.freq;
                return true;
            }
            this.positionState = PositionState.noMorePositions;
        } else if (this.positionState == PositionState.calced) {
            return true;
        }
        return false;
    }

    private void resetPositions(int docID) throws IOException {
        for (Item item : this.postList) {
            item.resetPosition(docID);
        }
    }

    protected abstract boolean advanceToNextPosition() throws IOException;

    @Override
    public float getBoost() {
        if (this.postList.isEmpty()) {
            return 0.0f;
        }
        float score = 0.0f;
        for (Item item : this.postList) {
            score += item.getBoost();
        }
        return score /= (float)this.postList.size();
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (Item item : this.postList) {
            item.getExplain(subs, context, doc);
        }
        return Explanation.match((Number)Float.valueOf(this.getBoost()), "phrase of:", subs);
    }

    private static enum PositionState {
        uninitialized,
        uncalced,
        calced,
        noMorePositions;

    }

    public static abstract class Item {
        public PostingsEnum postings;
        public Term term;
        public int freqState;
        public int postPos;

        public Item(PostingsEnum postings, Term term) {
            this.postings = postings;
            this.term = term;
        }

        public abstract DocIdSetIterator createApproximation();

        public abstract void resetPosition(int var1) throws IOException;

        public abstract State nextPosition() throws IOException;

        public abstract State advancePosition(int var1) throws IOException;

        public abstract int getMatchBgn();

        public abstract int getMatchEnd();

        public float getBoost() {
            float score = 0.0f;
            if (this.postings instanceof PostingsEnumBase) {
                PostingsEnumBase basePost = (PostingsEnumBase)this.postings;
                score = basePost.getBoost();
            } else {
                score = 1.0f;
            }
            return score;
        }

        public void getExplain(List<Explanation> subs, LeafReaderContext context, int doc) {
            Explanation expl = null;
            if (this.postings instanceof PostingsEnumBase) {
                PostingsEnumBase basePost = (PostingsEnumBase)this.postings;
                expl = basePost.explain(context, doc);
            } else if (this.term != null) {
                expl = Explanation.match((Number)1, this.term.toString(), new Explanation[0]);
            }
            if (expl != null) {
                subs.add(expl);
            }
        }

        public static enum State {
            Found,
            NotFound,
            Finished;

        }
    }
}

