/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumDoc
extends PostingsEnumBase {
    private final IntList matchDocList = new IntArrayList();
    private final Int2ObjectMap<IntList> referencedDocs = new Int2ObjectOpenHashMap<IntList>();
    private int pos = -1;
    private int currentDocId = -1;
    private final float boost;

    PostingsEnumDoc(float boost) {
        this.boost = boost;
    }

    void addMatchList(IntList matchDocList, int referencedDoc, int docBase) {
        int docId;
        IntListIterator intListIterator = matchDocList.iterator();
        while (intListIterator.hasNext()) {
            docId = (Integer)intListIterator.next();
            this.matchDocList.add(docId - docBase);
        }
        intListIterator = matchDocList.iterator();
        while (intListIterator.hasNext()) {
            docId = (Integer)intListIterator.next();
            IntList oldValue = (IntList)this.referencedDocs.get(docId);
            if (oldValue == null) {
                oldValue = new IntArrayList();
                oldValue.add(referencedDoc);
                this.referencedDocs.put(docId, oldValue);
                continue;
            }
            if (oldValue.contains(referencedDoc)) continue;
            oldValue.add(referencedDoc);
        }
    }

    void commit() {
        Collections.sort(this.matchDocList);
    }

    @Override
    public int docID() {
        return this.currentDocId;
    }

    @Override
    public int nextDoc() throws IOException {
        ++this.pos;
        return this.moveToPos(this.pos);
    }

    @Override
    public int advance(int target) throws IOException {
        this.pos = Collections.binarySearch(this.matchDocList, target);
        if (this.pos < 0) {
            this.pos = -1 - this.pos;
        }
        return this.moveToPos(this.pos);
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    private int moveToPos(int pos) {
        this.currentDocId = pos < this.matchDocList.size() ? this.matchDocList.getInt(pos) : Integer.MAX_VALUE;
        return this.currentDocId;
    }

    @Override
    public long cost() {
        return this.matchDocList.size();
    }

    @Override
    public int freq() throws IOException {
        if (this.referencedDocs.containsKey(this.currentDocId)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int nextPosition() throws IOException {
        return -1;
    }

    @Override
    public int startOffset() throws IOException {
        return -1;
    }

    @Override
    public int endOffset() throws IOException {
        return -1;
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return null;
    }

    @Override
    public IntList getReferencedDocList() {
        if (this.currentDocId != -1) {
            return (IntList)this.referencedDocs.get(this.currentDocId);
        }
        return null;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        return Explanation.match((Number)Float.valueOf(this.boost), "Found in document", new Explanation[0]);
    }
}

