/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumDisjunct
extends PostingsEnumBase {
    protected int doc = -1;
    private int minPosIndex = -1;
    protected int freq = 0;
    private int freqState = 0;
    protected final Item[] postList;
    protected final PostingsEnum[] postings;
    protected int firstItem;

    PostingsEnumDisjunct(List<Item> list) {
        this.postList = new Item[list.size()];
        this.postings = new PostingsEnum[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.postList[i] = list.get(i);
            this.postings[i] = this.postList[i].postings;
        }
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.doc != Integer.MAX_VALUE) {
            int minDoc = Integer.MAX_VALUE;
            for (PostingsEnum post : this.postings) {
                int d = post.docID();
                if (d <= this.doc) {
                    d = post.nextDoc();
                }
                if (d >= minDoc) continue;
                minDoc = d;
            }
            this.doc = minDoc;
            if (this.doc != Integer.MAX_VALUE) {
                this.resetPositions(this.doc);
                this.freq = 0;
                this.freqState = 0;
            }
        }
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        this.doc = Integer.MAX_VALUE;
        for (PostingsEnum post : this.postings) {
            int d = post.docID();
            if (d < target) {
                d = post.advance(target);
            }
            if (d >= this.doc) continue;
            this.doc = d;
        }
        if (this.doc != Integer.MAX_VALUE) {
            this.resetPositions(this.doc);
            this.freq = 0;
            this.freqState = 0;
        }
        return this.doc;
    }

    @Override
    public long cost() {
        long sumCost = 0L;
        for (PostingsEnum post : this.postings) {
            long c = post.cost();
            if (c <= 0L) continue;
            sumCost += c;
        }
        return sumCost;
    }

    @Override
    public int freq() throws IOException {
        if (this.freq == this.freqState) {
            this.freq = 0;
            if (this.doc != -1 && this.doc != Integer.MAX_VALUE) {
                int i = this.firstItem;
                while (i != -1) {
                    Item item = this.postList[i];
                    int f = item.postings.freq();
                    if (f > 0) {
                        this.freq += f;
                    }
                    i = item.nextItem;
                }
            }
        }
        return this.freq;
    }

    protected int resetPositions(int docID) throws IOException {
        int matchingDocNum = 0;
        this.freq = 0;
        this.freqState = 0;
        this.minPosIndex = -1;
        this.firstItem = -1;
        int i = this.postList.length;
        while (i > 0) {
            Item item = this.postList[--i];
            if (item.postings.docID() == docID) {
                item.freqState = 0;
                item.pos = -1;
                item.nextItem = this.firstItem;
                this.firstItem = i;
                ++matchingDocNum;
                continue;
            }
            item.pos = -2;
        }
        return matchingDocNum;
    }

    @Override
    public int nextPosition() throws IOException {
        int lastMinPosIndex = this.minPosIndex;
        this.minPosIndex = -1;
        ++this.freqState;
        if (this.doc != -1 && this.doc != Integer.MAX_VALUE) {
            if (this.freqState == 1) {
                return this.firstPosition();
            }
            return this.advancePosition(lastMinPosIndex);
        }
        return Integer.MAX_VALUE;
    }

    private int firstPosition() throws IOException {
        int minpos = Integer.MAX_VALUE;
        int prevItem = -1;
        int i = this.firstItem;
        while (i != -1) {
            Item item = this.postList[i];
            if (item.postings.freq() > item.freqState) {
                item.pos = item.postings.nextPosition() + item.posBase;
                ++item.freqState;
                if (item.pos < minpos) {
                    minpos = item.pos;
                    this.minPosIndex = i;
                }
            } else {
                item.pos = -2;
                if (prevItem == -1) {
                    this.firstItem = i;
                } else {
                    this.postList[prevItem].nextItem = i;
                }
            }
            prevItem = i;
            i = item.nextItem;
        }
        return minpos;
    }

    private int advancePosition(int lastMinPosIndex) throws IOException {
        if (lastMinPosIndex != -1) {
            Item mItem = this.postList[lastMinPosIndex];
            if (mItem.postings.freq() > mItem.freqState) {
                mItem.pos = mItem.postings.nextPosition() + mItem.posBase;
                ++mItem.freqState;
            } else {
                mItem.pos = Integer.MAX_VALUE;
            }
        }
        int minPos = Integer.MAX_VALUE;
        int i = this.firstItem;
        while (i != -1) {
            Item item = this.postList[i];
            int curpos = item.pos;
            if (item.posBase > minPos) break;
            if (curpos < minPos) {
                minPos = curpos;
                this.minPosIndex = i;
            }
            i = item.nextItem;
        }
        return minPos;
    }

    @Override
    public int startOffset() throws IOException {
        if (this.minPosIndex != -1) {
            return this.postList[this.minPosIndex].postings.startOffset();
        }
        return -1;
    }

    @Override
    public int endOffset() throws IOException {
        if (this.minPosIndex != -1) {
            return this.postList[this.minPosIndex].postings.endOffset();
        }
        return -1;
    }

    @Override
    public BytesRef getPayload() throws IOException {
        if (this.minPosIndex != -1) {
            return this.postList[this.minPosIndex].postings.getPayload();
        }
        return null;
    }

    @Override
    public int getPhraseEnd() {
        if (this.minPosIndex != -1) {
            PostingsEnumBase basePost;
            int phraseEnd;
            Item item = this.postList[this.minPosIndex];
            PostingsEnum posting = item.postings;
            if (posting instanceof PostingsEnumBase && (phraseEnd = (basePost = (PostingsEnumBase)posting).getPhraseEnd()) != -1) {
                return item.posBase + basePost.getPhraseEnd();
            }
        }
        return -1;
    }

    @Override
    public boolean foundInCommonField() {
        if (this.minPosIndex != -1) {
            Item item = this.postList[this.minPosIndex];
            return item.isCommonField;
        }
        return false;
    }

    @Override
    public float getBoost() {
        float score = 1.0f;
        if (this.minPosIndex != -1) {
            Item item = this.postList[this.minPosIndex];
            if (item.boost != null) {
                score = item.boost.computeBoost(item.pos, item.postings);
            }
            if (item.postings instanceof PostingsEnumBase) {
                PostingsEnumBase basePost = (PostingsEnumBase)item.postings;
                score *= basePost.getBoost();
            }
        }
        return score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        Explanation expl = null;
        if (this.minPosIndex != -1) {
            float score;
            Item item = this.postList[this.minPosIndex];
            if (item.postings instanceof PostingsEnumBase) {
                PostingsEnumBase basePost = (PostingsEnumBase)item.postings;
                expl = basePost.explain(context, doc);
            } else if (item.term != null) {
                expl = Explanation.match((Number)1, item.term.toString(), new Explanation[0]);
            }
            if (item.boost != null && (score = item.boost.computeBoost(item.pos, item.postings)) != 1.0f) {
                float childScore = expl == null ? 1.0f : expl.getValue().floatValue();
                expl = Explanation.match((Number)Float.valueOf(childScore * score), item.boost.explainBoost(item.pos, item.postings), expl);
            }
        } else {
            for (Item postItem : this.postList) {
                if (postItem.postings.docID() != doc) continue;
                if (postItem.postings instanceof PostingsEnumBase) {
                    PostingsEnumBase basePost = (PostingsEnumBase)postItem.postings;
                    return basePost.explain(context, doc);
                }
                if (postItem.term == null) continue;
                return Explanation.match((Number)1, postItem.term.toString(), new Explanation[0]);
            }
        }
        return expl;
    }

    @Override
    public IntList getReferencedDocList() {
        PostingsEnum posting;
        if (this.minPosIndex != -1 && (posting = this.postList[this.minPosIndex].postings) instanceof PostingsEnumBase) {
            PostingsEnumBase basePost = (PostingsEnumBase)posting;
            return basePost.getReferencedDocList();
        }
        return null;
    }

    public static class Item {
        public PostingsEnum postings;
        public Term term;
        public PSolBoost boost;
        public int posBase;
        public int pos;
        public int freqState;
        public int nextItem;
        public boolean isCommonField;

        public Item(PostingsEnum postings, Term term) {
            this(postings, term, null, 0, false);
        }

        public Item(PostingsEnum postings, Term term, PSolBoost boost, int posBase, boolean isCommonField) {
            this.postings = postings;
            this.term = term;
            this.boost = boost;
            this.posBase = posBase;
            this.isCommonField = isCommonField;
        }
    }
}

