/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumBoost
extends PostingsEnumBase {
    private final PostingsEnumData childData;
    private final PostingsEnum child;
    private final PSolBoost boost;
    private int pos;

    PostingsEnumBoost(PostingsEnumData child, PSolBoost boost) {
        this.childData = child;
        this.child = child.postings;
        this.boost = boost;
        this.pos = -1;
    }

    @Override
    public int docID() {
        return this.child.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.child.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.child.advance(target);
    }

    @Override
    public long cost() {
        return this.child.cost();
    }

    @Override
    public int freq() throws IOException {
        return this.child.freq();
    }

    @Override
    public int nextPosition() throws IOException {
        this.pos = this.child.nextPosition();
        return this.pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.child.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.child.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.child.getPayload();
    }

    @Override
    public int getPhraseEnd() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).getPhraseEnd();
        }
        return super.getPhraseEnd();
    }

    @Override
    public boolean foundInCommonField() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).foundInCommonField();
        }
        return super.foundInCommonField();
    }

    @Override
    public float getBoost() {
        float score = this.child instanceof PostingsEnumBase ? ((PostingsEnumBase)this.child).getBoost() : 1.0f;
        return score *= this.boost.computeBoost(this.pos, this.child);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        Explanation expl = this.child instanceof PostingsEnumBase ? ((PostingsEnumBase)this.child).explain(context, doc) : (this.childData.term != null ? Explanation.match((Number)1, this.childData.term.toString(), new Explanation[0]) : null);
        float score = this.boost.computeBoost(this.pos, this.child);
        if (score != 1.0f) {
            float childScore = expl == null ? 1.0f : expl.getValue().floatValue();
            expl = Explanation.match((Number)Float.valueOf(childScore * score), this.boost.explainBoost(this.pos, this.child), expl);
        }
        return expl;
    }

    @Override
    public IntList getReferencedDocList() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).getReferencedDocList();
        }
        return super.getReferencedDocList();
    }
}

