/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumExact;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class PSolWeightItemExact
extends PSolWeightItem {
    private final PSolWeightItem child;
    private final FieldDefinitions.WordPart wordPart;

    PSolWeightItemExact(PSolWeightItem child, FieldDefinitions.WordPart wordPart) {
        this.child = child;
        this.wordPart = wordPart;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        PostingsEnumData childData = this.child.getPostingsEnum(context, true);
        if (childData == null) {
            return null;
        }
        PostingsEnumExact childPost = new PostingsEnumExact(childData, this.wordPart);
        return new PostingsEnumData(childPost, null, childData.matchCost);
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        this.child.extractTerms(queryTerms, queryConsumer);
    }

    @Override
    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        this.child.extractWeightedSpanTerms(context, fieldName, terms, queryConsumer);
    }

    @Override
    public String getSearchField() {
        return this.child.getSearchField();
    }
}

