/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumDoc;
import de.cadenas.util.PDataStream;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.util.BytesRef;

public class PSolWeightItemDoc
extends PSolWeightItem {
    private final PSolWeightItem subWeight;
    private final String docIdField;

    PSolWeightItemDoc(PSolWeightItem subWeight, String docIdField) {
        this.subWeight = subWeight;
        this.docIdField = docIdField;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        DocValuesIterator docValues = null;
        PostingsEnumData subData = this.subWeight.getPostingsEnum(context, needPayload);
        if (subData != null && subData.postings != null) {
            PostingsEnumDoc docData = null;
            float boost = 1.0f;
            Int2ObjectOpenHashMap<IntArrayList> idLookup = new Int2ObjectOpenHashMap<IntArrayList>();
            while (subData.postings.nextDoc() != Integer.MAX_VALUE) {
                int lineId;
                IntArrayList lineIds;
                String path;
                BytesRef binaryData;
                if (docValues == null) {
                    docValues = DocValues.getBinary(context.getLeafReaderContext().reader(), this.docIdField);
                }
                if (!docValues.advanceExact(subData.postings.docID())) continue;
                if (subData.postings instanceof PostingsEnumBase) {
                    boost = ((PostingsEnumBase)subData.postings).getBoost();
                }
                if ((binaryData = ((BinaryDocValues)docValues).binaryValue()) == null) continue;
                try {
                    PDataStream stream = new PDataStream(binaryData);
                    String string = stream.readString();
                    path = stream.readString();
                    int lineCount = stream.readInt();
                    lineIds = new IntArrayList();
                    for (int i = 0; i < lineCount; ++i) {
                        lineId = stream.readInt();
                        lineIds.add(lineId);
                    }
                }
                catch (Exception ignored) {
                    return null;
                }
                if (lineIds.isEmpty()) continue;
                IDocIdIndex docIdIndex = null;
                try {
                    CompositeReader reader = context.getLeafReaderContext().parent.reader();
                    IIndexManager.IIndexReaderData container = ServiceFactory.getIndexManager().findReaderData(reader);
                    docIdIndex = container.getDocIdIndex();
                }
                catch (NullPointerException reader) {
                    // empty catch block
                }
                if (docIdIndex == null) continue;
                IntArrayList matchList = new IntArrayList();
                IntListIterator intListIterator = lineIds.iterator();
                while (intListIterator.hasNext()) {
                    lineId = (Integer)intListIterator.next();
                    IntList idList = docIdIndex.getDocIds(path, lineId);
                    if (idList.isEmpty()) continue;
                    matchList.addAll(idList);
                }
                if (matchList.isEmpty()) continue;
                idLookup.put(subData.postings.docID(), matchList);
            }
            if (!idLookup.isEmpty()) {
                docData = new PostingsEnumDoc(boost);
                for (Int2ObjectMap.Entry entry : idLookup.int2ObjectEntrySet()) {
                    docData.addMatchList((IntList)entry.getValue(), entry.getIntKey(), context.getLeafReaderContext().docBaseInParent);
                }
                docData.commit();
            }
            if (docData != null) {
                return new PostingsEnumData(docData, null, 1.0f);
            }
        }
        return null;
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        this.subWeight.extractTerms(queryTerms, queryConsumer);
    }

    @Override
    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        this.subWeight.extractWeightedSpanTerms(context, fieldName, terms, queryConsumer);
    }

    @Override
    public String getSearchField() {
        return this.subWeight.getSearchField();
    }
}

