/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class PSolWeightItemBoost
extends PSolWeightItem {
    private final PSolWeightItem child;
    private final PSolBoost boost;

    PSolWeightItemBoost(PSolWeightItem child, PSolBoost boost) {
        this.child = child;
        this.boost = boost;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        PostingsEnumData childData = this.child.getPostingsEnum(context, true);
        if (childData == null) {
            return null;
        }
        PostingsEnumBoost childPost = new PostingsEnumBoost(childData, this.boost);
        return new PostingsEnumData(childPost, null, childData.matchCost);
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        this.child.extractTerms(queryTerms, queryConsumer);
    }

    @Override
    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        this.child.extractWeightedSpanTerms(context, fieldName, terms, queryConsumer);
    }

    @Override
    public String getSearchField() {
        return this.child.getSearchField();
    }
}

