/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public abstract class PSolWeightItem {
    private boolean compoundPart = false;

    public abstract PostingsEnumData getPostingsEnum(ContextCache var1, boolean var2) throws IOException;

    public abstract void extractTerms(Set<Term> var1, Consumer<Query> var2);

    public abstract String getSearchField();

    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        HashSet<Term> nonWeightedTerms = new HashSet<Term>();
        this.extractTerms(nonWeightedTerms, queryConsumer);
        for (Term queryTerm : nonWeightedTerms) {
            if (!queryTerm.field().startsWith(fieldName)) continue;
            WeightedSpanTerm weightedSpanTerm = new WeightedSpanTerm(1.0f, queryTerm.text());
            terms.put(queryTerm.text(), weightedSpanTerm);
        }
    }

    public void setCompoundPart(boolean yesno) {
        this.compoundPart = yesno;
    }

    public boolean isCompoundPart() {
        return this.compoundPart;
    }
}

