/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolScorer;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class PSolWeight
extends Weight {
    private final PSolWeightItem[] weightList;
    private float simWeight;
    private final boolean checkInCommonField;

    public PSolWeight(Query query, PSolWeightItem[] weightList, boolean checkInCommonField) {
        super(query);
        this.weightList = weightList;
        this.checkInCommonField = checkInCommonField;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        for (PSolWeightItem item : this.weightList) {
            item.extractTerms(queryTerms, queryConsumer);
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Explanation explain;
        PSolScorer scorer = (PSolScorer)this.scorer(context);
        if (scorer != null && (explain = scorer.explain(context, doc)) != null) {
            return explain;
        }
        return Explanation.noMatch("psolquery not matching", new Explanation[0]);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        PostingsEnumData[] postingList = this.getPostingList(context, false);
        if (postingList == null) {
            return null;
        }
        return new PSolScorer(this, postingList, context, this.checkInCommonField);
    }

    private PostingsEnumData[] getPostingList(LeafReaderContext context, boolean needPayload) throws IOException {
        PSolQuery query = (PSolQuery)this.parentQuery;
        ContextCache contextCache = new ContextCache(context);
        PostingsEnumData[] postingList = new PostingsEnumData[this.weightList.length];
        for (int i = 0; i < this.weightList.length; ++i) {
            PostingsEnumData data = this.weightList[i].getPostingsEnum(contextCache, needPayload);
            if (data == null) {
                return null;
            }
            postingList[i] = data;
        }
        return postingList;
    }

    public PostingsEnumData[] getCompletePostingList(LeafReaderContext context, boolean needPayload) throws IOException {
        PSolQuery query = (PSolQuery)this.parentQuery;
        ContextCache contextCache = new ContextCache(context);
        PostingsEnumData[] postingList = new PostingsEnumData[this.weightList.length];
        for (int i = 0; i < this.weightList.length; ++i) {
            PostingsEnumData data;
            postingList[i] = data = this.weightList[i].getPostingsEnum(contextCache, needPayload);
        }
        return postingList;
    }

    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        for (PSolWeightItem weightItem : this.weightList) {
            weightItem.extractWeightedSpanTerms(context, fieldName, terms, queryConsumer);
        }
    }
}

