/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class PSolScorer
extends Scorer {
    private static final PLogger logger = new PLogger(PSolScorer.class.getSimpleName());
    private final DocIdSetIterator approximation;
    private final List<Item> postList;
    private final LeafReaderContext context;
    private final boolean checkInCommonField;
    private LongValues prioValues = null;
    private float lastScore = -1.0f;
    private int lastDocId = -1;
    private boolean isInCommonField = false;

    PSolScorer(Weight weight, PostingsEnumData[] postingList, LeafReaderContext context, boolean checkInCommonField) {
        super(weight);
        this.approximation = this.createApproximation(postingList);
        this.postList = this.createPostingsList(postingList);
        this.context = context;
        this.checkInCommonField = checkInCommonField;
    }

    public IntList getReferencedDocList() {
        if (this.postList != null && !this.postList.isEmpty() && this.postList.get((int)0).postings instanceof PostingsEnumBase) {
            PostingsEnumBase pb = (PostingsEnumBase)this.postList.get((int)0).postings;
            return pb.getReferencedDocList();
        }
        return null;
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        int docId = this.docID();
        if (this.lastScore != -1.0f && this.lastDocId == docId) {
            return this.lastScore;
        }
        this.lastDocId = docId;
        float score = 0.0f;
        if (this.firstPositions(docId)) {
            score = this.scorePositions(docId);
            this.isInCommonField = this.detectInCommonField();
            while (this.advancePosition(docId)) {
                float sc = this.scorePositions(docId);
                if (!this.isInCommonField) {
                    this.isInCommonField = this.detectInCommonField();
                }
                if (!(sc > score)) continue;
                score = sc;
            }
        } else {
            score = this.scorePositions(docId);
            this.isInCommonField = this.detectInCommonField();
        }
        this.lastScore = score = this.evaluateRowBoost(docId, score, null);
        return score;
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.approximation;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.MAX_VALUE;
    }

    public String toString() {
        return "PsolScorer(" + this.weight + ")";
    }

    private DocIdSetIterator createApproximation(PostingsEnumData[] postings) {
        if (postings.length == 1) {
            return postings[0].postings;
        }
        ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
        for (PostingsEnumData data : postings) {
            iterators.add(data.postings);
        }
        return ConjunctionUtils.intersectIterators(iterators);
    }

    private List<Item> createPostingsList(PostingsEnumData[] postings) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (PostingsEnumData data : postings) {
            list.add(new Item(data.postings));
        }
        return list;
    }

    private boolean firstPositions(int docID) throws IOException {
        boolean advanced = false;
        for (Item item : this.postList) {
            if (item.postings.freq() > 0) {
                item.pos = item.postings.nextPosition();
                item.freqState = 1;
                item.score = this.calculateScore(item.postings);
                advanced = true;
            } else {
                item.pos = -1;
                item.freqState = 0;
                item.score = this.calculateScore(item.postings);
            }
            item.foundAsPhrase = false;
        }
        return advanced;
    }

    boolean advancePosition(int docID) throws IOException {
        boolean advanced = false;
        int minPos = Integer.MAX_VALUE;
        int minIdx = -1;
        for (int i = 0; i < this.postList.size(); ++i) {
            Item item = this.postList.get(i);
            int curpos = item.pos;
            if (curpos >= minPos || item.postings.freq() <= item.freqState) continue;
            minPos = curpos;
            minIdx = i;
        }
        if (minIdx != -1) {
            Item mItem = this.postList.get(minIdx);
            mItem.pos = mItem.postings.nextPosition();
            ++mItem.freqState;
            mItem.score = this.calculateScore(mItem.postings);
            advanced = true;
        }
        return advanced;
    }

    private float scorePositions(int docId) throws IOException {
        Item item = this.postList.get(0);
        float scoreVal = item.score;
        for (int i = 1; i < this.postList.size(); ++i) {
            int phraseEnd = this.getPhraseEnd(item.postings);
            if (phraseEnd == -1) {
                phraseEnd = item.pos;
            }
            float payloadScore = this.postList.get((int)i).score;
            if (phraseEnd != -1) {
                item = this.postList.get(i);
                if (phraseEnd % 100000 < 10000) {
                    int nextPos = phraseEnd + 1;
                    if (item.pos == nextPos) {
                        payloadScore += 3.0f;
                        item.foundAsPhrase = true;
                    }
                } else {
                    int expectedPos3;
                    int expectedPos2;
                    int expectedPos1;
                    boolean endOfBlock;
                    boolean bl = endOfBlock = phraseEnd % 2 == 0;
                    if (endOfBlock) {
                        expectedPos1 = phraseEnd + (100 - phraseEnd % 100);
                        expectedPos2 = expectedPos1 + 1;
                        expectedPos3 = expectedPos1 + 2;
                    } else {
                        expectedPos1 = phraseEnd + 2;
                        expectedPos2 = -2;
                        expectedPos3 = phraseEnd + 3;
                    }
                    if (item.pos == expectedPos1 || item.pos == expectedPos2 || item.pos == expectedPos3) {
                        payloadScore += 3.0f;
                        item.foundAsPhrase = true;
                    }
                }
            }
            scoreVal += payloadScore;
        }
        return scoreVal;
    }

    private boolean detectInCommonField() {
        if (!this.checkInCommonField) {
            return false;
        }
        for (int i = 0; i < this.postList.size(); ++i) {
            if (this.foundInCommonField(this.postList.get((int)i).postings)) continue;
            return false;
        }
        return true;
    }

    private float calculateScore(PostingsEnum postings) {
        if (postings instanceof PostingsEnumBase) {
            PostingsEnumBase basePost = (PostingsEnumBase)postings;
            return basePost.getBoost();
        }
        return 1.0f;
    }

    private int getPhraseEnd(PostingsEnum postings) {
        if (postings instanceof PostingsEnumBase) {
            PostingsEnumBase basePost = (PostingsEnumBase)postings;
            return basePost.getPhraseEnd();
        }
        return -1;
    }

    private boolean foundInCommonField(PostingsEnum postings) {
        if (postings instanceof PostingsEnumBase) {
            PostingsEnumBase basePost = (PostingsEnumBase)postings;
            return basePost.foundInCommonField();
        }
        return false;
    }

    private float evaluateRowBoost(int docId, float score, List<Explanation> explanationList) {
        try {
            long longvalue;
            if (this.prioValues == null) {
                LongValuesSource lsrc = LongValuesSource.fromLongField("prio");
                this.prioValues = lsrc.getValues(this.context, null);
            }
            if (this.prioValues.advanceExact(docId) && (longvalue = this.prioValues.longValue()) != 0L) {
                for (FieldDefinitions.RowBoost boost : FieldDefinitions.rowBoost) {
                    if ((longvalue & boost.mask) == 0L) continue;
                    score = boost.multiply ? (score *= boost.factor) : (score += boost.factor);
                    if (explanationList == null) continue;
                    Explanation expl = boost.multiply ? Explanation.match((Number)Float.valueOf(boost.factor), "multiply with factor (" + boost.desc + ")", new Explanation[0]) : Explanation.match((Number)Float.valueOf(boost.factor), "add boost (" + boost.desc + ")", new Explanation[0]);
                    explanationList.add(expl);
                }
            }
        }
        catch (IOException e) {
            logger.error("error reading row prio " + e.getMessage());
        }
        return score;
    }

    public Explanation explain(LeafReaderContext context, int docId) throws IOException {
        int newDoc = this.iterator().advance(docId);
        if (newDoc == docId) {
            List<Explanation> subs;
            float score = 0.0f;
            if (this.firstPositions(docId)) {
                score = this.scorePositions(docId);
                subs = this.explainHelper(context, docId);
                while (this.advancePosition(docId)) {
                    float sc = this.scorePositions(docId);
                    if (!(sc > score)) continue;
                    score = sc;
                    subs = this.explainHelper(context, docId);
                }
            } else {
                score = this.scorePositions(docId);
                subs = this.explainHelper(context, docId);
            }
            score = this.evaluateRowBoost(docId, score, subs);
            return Explanation.match((Number)Float.valueOf(score), "sum of: (PSolQuery)", subs);
        }
        return null;
    }

    public List<Explanation> explainHelper(LeafReaderContext context, int doc) throws IOException {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        for (Item item : this.postList) {
            PostingsEnumBase basePost;
            Explanation expl = null;
            PostingsEnum postings = item.postings;
            if (!(postings instanceof PostingsEnumBase) || (expl = (basePost = (PostingsEnumBase)postings).explain(context, doc)) == null) continue;
            if (item.foundAsPhrase) {
                expl = Explanation.match((Number)Float.valueOf(expl.getValue().floatValue() + 3.0f), "found as phrase (+" + Float.toString(3.0f) + ")", expl);
            }
            subs.add(expl);
        }
        return subs;
    }

    public boolean foundInCommonField() {
        return this.isInCommonField;
    }

    public static class Item {
        public PostingsEnum postings;
        public int pos;
        public int freqState;
        public float score;
        public boolean foundAsPhrase;

        public Item(PostingsEnum postings) {
            this.postings = postings;
        }
    }
}

