/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeighItemWrapper;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class PSolQueryItemWrapper
extends PSolQueryItem {
    private final Query subQuery;

    public PSolQueryItemWrapper(Query subQuery) {
        this.subQuery = subQuery;
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        this.subQuery.visit(visitor);
    }

    @Override
    public String getSearchField() {
        return "";
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Query rquery = searcher.rewrite(this.subQuery);
        Weight weight = searcher.createWeight(rquery, scoreMode, boost);
        if (weight != null) {
            return new PSolWeighItemWrapper(weight);
        }
        return null;
    }

    public String toString() {
        return this.subQuery.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemWrapper other = (PSolQueryItemWrapper)obj;
        return this.subQuery.equals(other.subQuery);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + this.subQuery.hashCode();
        return h;
    }

    public Query getQuery() {
        return this.subQuery;
    }
}

