/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.IFieldQueryVisitor;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemAutomaton;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.WildcardQuery;

public class PSolQueryItemWildcard
extends PSolQueryItemAutomaton {
    private final Term term;

    public PSolQueryItemWildcard(Term wildcard, AtomicLong costLimit) {
        super(wildcard, costLimit, WildcardQuery.toAutomaton(wildcard), 10000, false);
        this.term = wildcard;
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        if ((this.term.field().startsWith("col_text_") || this.term.field().startsWith("textvalues")) && visitor instanceof IFieldQueryVisitor) {
            IFieldQueryVisitor fqv = (IFieldQueryVisitor)((Object)visitor);
            fqv.visit(this.term.field(), new WildcardQuery(this.term, 10000));
        }
    }

    public String toString() {
        return this.term.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemWildcard other = (PSolQueryItemWildcard)obj;
        if (this.term == null) {
            return other.term == null;
        }
        return this.term.equals(other.term);
    }

    public int hashCode() {
        return this.term.hashCode();
    }
}

