/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.IFieldQueryVisitor;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItemPhrase;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemPhrase
extends PSolQueryItem {
    private final List<PSolQueryItem> itemList;
    private final boolean isStrict;
    private final boolean isCompoundPhrase;

    public PSolQueryItemPhrase(List<PSolQueryItem> itemList, boolean isCompoundPhrase, boolean isStrict) {
        this.itemList = itemList;
        this.isCompoundPhrase = isCompoundPhrase;
        this.isStrict = isStrict;
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        PSolWeightItem[] weightList = new PSolWeightItem[this.itemList.size()];
        for (int i = 0; i < this.itemList.size(); ++i) {
            PSolQueryItem queryItem = this.itemList.get(i);
            PSolWeightItem subItem = queryItem.createWeightItem(searcher, scoreMode, boost);
            if (subItem == null) {
                return null;
            }
            subItem.setCompoundPart(queryItem.isCompoundPart());
            weightList[i] = subItem;
        }
        return new PSolWeightItemPhrase(weightList, this.isCompoundPhrase, this.isStrict);
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        if (visitor instanceof IFieldQueryVisitor) {
            IFieldQueryVisitor iv = (IFieldQueryVisitor)((Object)visitor);
            PSolQuery partQuery = new PSolQuery(this);
            iv.visit(this.getSearchField(), partQuery);
        } else {
            for (PSolQueryItem item : this.itemList) {
                item.collectTerms(query, visitor);
            }
        }
    }

    @Override
    public String getSearchField() {
        for (PSolQueryItem item : this.itemList) {
            String field = item.getSearchField();
            if (field.isEmpty()) continue;
            return field;
        }
        return "";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (i != 0) {
                buffer.append(' ');
            }
            buffer.append(this.itemList.get(i).toString());
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemPhrase other = (PSolQueryItemPhrase)obj;
        return this.itemList.equals(other.itemList);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + this.itemList.hashCode();
        return h;
    }

    public List<PSolQueryItem> getItemList() {
        return this.itemList;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean isCompoundPhrase() {
        return this.isCompoundPhrase;
    }
}

