/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItemExact;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemExact
extends PSolQueryItem {
    private final PSolQueryItemTerm child;
    private final FieldDefinitions.WordPart wordPart;

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        this.child.collectTerms(query, visitor);
    }

    @Override
    public String getSearchField() {
        return this.child.getSearchField();
    }

    public PSolQueryItemTerm getTermQuery() {
        return this.child;
    }

    public PSolQueryItemExact(PSolQueryItemTerm child, FieldDefinitions.WordPart wordPart) {
        this.child = child;
        this.wordPart = wordPart;
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        PSolWeightItem subItem = this.child.createWeightItem(searcher, scoreMode, boost);
        if (subItem == null) {
            return null;
        }
        return new PSolWeightItemExact(subItem, this.wordPart);
    }

    public String toString() {
        return this.child.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemExact other = (PSolQueryItemExact)obj;
        return this.child.equals(other.child);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + this.child.hashCode();
        return h;
    }
}

