/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.IFieldQueryVisitor;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeigthItemDefault;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumAutomaton;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumDisjunct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class PSolQueryItemAutomaton
extends PSolQueryItem {
    private final CompiledAutomaton compiled;
    private final Term term;
    private final AtomicLong costLimit;

    PSolQueryItemAutomaton(Term term, AtomicLong costLimit, Automaton automaton, int maxDeterminizedStates, boolean isBinary) {
        this.term = term;
        this.compiled = new CompiledAutomaton(automaton, null, true, maxDeterminizedStates, isBinary);
        this.costLimit = costLimit;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new PSolWeigthItemDefault(this){

            @Override
            public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
                Terms terms = context.getTerms(PSolQueryItemAutomaton.this.term.field());
                if (terms == null) {
                    return null;
                }
                ArrayList<PostingsEnumDisjunct.Item> list = new ArrayList<PostingsEnumDisjunct.Item>();
                TermsEnum te = PSolQueryItemAutomaton.this.compiled.getTermsEnum(terms);
                float matchCost = 0.0f;
                BytesRef bytes = te.next();
                while (bytes != null) {
                    PostingsEnum postingsEnum = te.postings(null, 24);
                    list.add(new PostingsEnumDisjunct.Item(postingsEnum, PSolQueryItemAutomaton.this.term));
                    matchCost += PSolQueryItemAutomaton.this.termPositionsCost(te);
                    bytes = te.next();
                }
                if (list.size() > 0 && PSolQueryItemAutomaton.this.costLimit.get() >= 0L) {
                    PostingsEnumAutomaton mpost = new PostingsEnumAutomaton(list, PSolQueryItemAutomaton.this.costLimit);
                    return new PostingsEnumData(mpost, PSolQueryItemAutomaton.this.term, matchCost);
                }
                return null;
            }

            @Override
            public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
            }

            @Override
            public String getSearchField() {
                return PSolQueryItemAutomaton.this.term.field();
            }

            @Override
            public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
                LeafReader reader = context.reader();
                Terms fieldTerms = reader.terms(fieldName);
                if (fieldTerms == null) {
                    return;
                }
                TermsEnum te = PSolQueryItemAutomaton.this.compiled.getTermsEnum(fieldTerms);
                BytesRef bytes = te.next();
                while (bytes != null) {
                    String termText = bytes.utf8ToString();
                    if (!terms.containsKey(termText)) {
                        terms.put(termText, new WeightedSpanTerm(1.0f, termText));
                    }
                    bytes = te.next();
                }
            }
        };
    }

    @Override
    public String getSearchField() {
        return this.term.field();
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        if ((this.term.field().startsWith("col_text_") || this.term.field().startsWith("textvalues")) && visitor instanceof IFieldQueryVisitor) {
            IFieldQueryVisitor fqv = (IFieldQueryVisitor)((Object)visitor);
            fqv.visit(this.term.field(), new WildcardQuery(this.term, 10000));
        }
    }
}

