/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeight;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class PSolQuery
extends Query {
    private final List<PSolQueryItem> items;
    private boolean checkInCommonField = false;

    public PSolQuery(PSolQueryItem item) {
        this(Collections.singletonList(item));
    }

    public PSolQuery(List<PSolQueryItem> items) {
        this.items = items;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (this.items != null) {
            for (PSolQueryItem item : this.items) {
                item.collectTerms(this, visitor);
            }
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PSolQuery(");
        for (PSolQueryItem item : this.items) {
            buffer.append(item.toString());
            buffer.append(' ');
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQuery other = (PSolQuery)obj;
        if (this.items == null) {
            return other.items == null;
        }
        return this.items.equals(other.items);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (PSolQueryItem item : this.items) {
            result = 31 * result + item.hashCode();
        }
        return result;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        PSolWeightItem[] weightList = new PSolWeightItem[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            weightList[i] = this.items.get(i).createWeightItem(searcher, scoreMode, boost);
        }
        return new PSolWeight(this, weightList, this.checkInCommonField);
    }

    public List<PSolQueryItem> getQueryItems() {
        return this.items;
    }

    public void setCheckInCommonField(boolean yesno) {
        this.checkInCommonField = yesno;
    }
}

