/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.boost;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import org.apache.lucene.index.PostingsEnum;

public class PSolStandardBoost
extends PSolBoost {
    private float lowPrioBoost;

    public PSolStandardBoost(float lowPrioBoost) {
        this.lowPrioBoost = lowPrioBoost;
    }

    public void setLowPrioBoost(float boostValue) {
        this.lowPrioBoost = boostValue;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public float computeBoost(int position, PostingsEnum posting) {
        byte b = PSolStandardBoost.getTokenPriority(posting);
        return PSolStandardBoost.isLowTokenPriority(b) ? this.lowPrioBoost : 1.0f;
    }

    @Override
    public String explainBoost(int position, PostingsEnum posting) {
        return "factor  (alternate match): " + this.lowPrioBoost;
    }

    @Override
    public float defaultBoost() {
        return 1.0f;
    }

    @Override
    public boolean needPositions() {
        return true;
    }
}

