/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.boost;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import org.apache.lucene.index.PostingsEnum;

public class PSolFieldBoost
extends PSolBoost {
    private float og;
    private float ug;
    private float step;
    private boolean needPositions;

    public PSolFieldBoost(float og, float ug, float step) {
        this.og = og;
        this.ug = ug;
        this.step = step;
        this.needPositions = og >= ug && step != 0.0f;
    }

    public PSolFieldBoost(float fixBoost, boolean needPositions) {
        this.og = fixBoost;
        this.ug = fixBoost;
        this.step = 0.0f;
        this.needPositions = needPositions;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setFixBoost(float val) {
        this.ug = val;
        this.og = val;
    }

    public void setUg(float ug) {
        this.ug = ug;
    }

    public void setOg(float og) {
        this.og = og;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public void setNeedPositions(boolean needPositions) {
        this.needPositions = needPositions;
    }

    @Override
    public float computeBoost(int position, PostingsEnum postings) {
        if (position < 0 || !this.needPositions) {
            return this.ug;
        }
        int pos = position % 100000;
        if (pos >= 10000) {
            int cpos = pos - 10000;
            pos = cpos / 100;
        }
        if (this.og < this.ug) {
            return this.ug;
        }
        return this.og - this.step * (float)pos;
    }

    @Override
    public String explainBoost(int position, PostingsEnum postings) {
        if (position < 0 || !this.needPositions) {
            return "factor by field: " + this.ug;
        }
        if (this.step == 0.0f) {
            return "factor by field: " + this.og;
        }
        int pos = position % 100000;
        if (pos >= 10000) {
            int cpos = pos - 10000;
            pos = cpos / 100;
        }
        String calcualation = this.og + " - " + pos + " * " + this.step;
        return "factor by field: " + calcualation;
    }

    @Override
    public float defaultBoost() {
        return this.og;
    }

    @Override
    public boolean needPositions() {
        return this.needPositions;
    }
}

