/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.LexerToken;
import de.cadenas.catalogsearch.lucene.queryparser.SearchField;
import de.cadenas.catalogsearch.lucene.queryparser.TokenType;
import java.util.ArrayList;
import java.util.List;

public class QueryParserData {
    private final List<LexerToken> tokens;
    private final List<String> languageList;
    private final String erpGroup;
    int pos;
    private boolean textSearchFieldsSet = false;
    private boolean numSearchFieldsSet = false;
    private boolean exactSearchFieldsSet = false;
    private boolean phraseSearchFieldsSet = false;
    private boolean wildcardFieldsSet = false;
    private List<SearchField> textSearchFields = null;
    private List<SearchField> numSearchFields = null;
    private List<SearchField> exactSearchFields = null;
    private List<SearchField> phraseSearchFields = null;
    private List<SearchField> wildcardFields = null;
    private static final LexerToken eofToken = new LexerToken(null, TokenType.TT_EOF);

    QueryParserData(List<LexerToken> tok, List<String> llist, String erpGroup) {
        this.tokens = tok;
        this.languageList = llist;
        this.pos = 0;
        this.erpGroup = erpGroup;
    }

    public boolean isEof() {
        return this.pos >= this.tokens.size();
    }

    public LexerToken takeNextToken() {
        if (this.pos < this.tokens.size()) {
            return this.tokens.get(this.pos++);
        }
        return eofToken;
    }

    public List<LexerToken> takeTokensUntil(TokenType until) {
        ArrayList<LexerToken> result = new ArrayList<LexerToken>();
        while (this.pos < this.tokens.size() && this.tokens.get((int)this.pos).type != until) {
            result.add(this.tokens.get(this.pos));
            ++this.pos;
        }
        return result;
    }

    public LexerToken peekNextToken() {
        if (this.pos < this.tokens.size()) {
            return this.tokens.get(this.pos);
        }
        return eofToken;
    }

    public LexerToken peekNextToken(int offset) {
        if (this.pos + offset < this.tokens.size()) {
            return this.tokens.get(this.pos + offset);
        }
        return eofToken;
    }

    public TokenType peekNextTokenType() {
        if (this.pos < this.tokens.size()) {
            return this.tokens.get((int)this.pos).type;
        }
        return TokenType.TT_EOF;
    }

    public void removeNextToken() {
        if (this.pos < this.tokens.size()) {
            ++this.pos;
        }
    }

    public List<String> getLanguageList() {
        return this.languageList;
    }

    public String getErpGroup() {
        return this.erpGroup;
    }

    public void setTextSearchFields(List<SearchField> fields) {
        this.textSearchFields = fields;
        this.textSearchFieldsSet = true;
    }

    public void setNumericSearchFields(List<SearchField> fields) {
        this.numSearchFields = fields;
        this.numSearchFieldsSet = true;
    }

    public void setWildcardFields(List<SearchField> fields) {
        this.wildcardFields = fields;
        this.wildcardFieldsSet = true;
    }

    public void setExactFields(List<SearchField> fields) {
        this.exactSearchFields = fields;
        this.exactSearchFieldsSet = true;
    }

    public void setPhraseFields(List<SearchField> fields) {
        this.phraseSearchFields = fields;
        this.phraseSearchFieldsSet = true;
    }

    public List<SearchField> getTextSearchFields() {
        if (this.textSearchFieldsSet) {
            return this.textSearchFields;
        }
        this.textSearchFieldsSet = true;
        this.textSearchFields = FieldDefinitions.getTextualFields(this.languageList, this.erpGroup);
        return this.textSearchFields;
    }

    public List<SearchField> getNumericSearchFields() {
        if (this.numSearchFieldsSet) {
            return this.numSearchFields;
        }
        this.numSearchFieldsSet = true;
        this.numSearchFields = FieldDefinitions.getNumericFields(this.erpGroup);
        return this.numSearchFields;
    }

    public List<SearchField> getExactSearchFields() {
        if (this.exactSearchFieldsSet) {
            return this.exactSearchFields;
        }
        this.exactSearchFieldsSet = true;
        this.exactSearchFields = FieldDefinitions.getExactFields(this.languageList, this.erpGroup);
        return this.exactSearchFields;
    }

    public List<SearchField> getPhraseSearchFields() {
        if (this.phraseSearchFieldsSet) {
            return this.phraseSearchFields;
        }
        this.phraseSearchFieldsSet = true;
        this.phraseSearchFields = FieldDefinitions.getPhraseFields(this.languageList, this.erpGroup);
        return this.phraseSearchFields;
    }

    public List<SearchField> getWildcardFields() {
        if (this.wildcardFieldsSet) {
            return this.wildcardFields;
        }
        this.wildcardFieldsSet = true;
        this.wildcardFields = FieldDefinitions.getWildcardFields();
        return this.wildcardFields;
    }

    public static List<SearchField> merge(List<SearchField> list1, List<SearchField> list2) {
        ArrayList<SearchField> result = new ArrayList<SearchField>();
        if (list1 != null) {
            result.addAll(list1);
        }
        if (list2 != null) {
            result.addAll(list2);
        }
        return result;
    }
}

