/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser;

import de.cadenas.catalogsearch.lucene.queryparser.LexerToken;
import de.cadenas.catalogsearch.lucene.queryparser.TokenType;
import de.cadenas.util.NumUtils;
import java.util.ArrayList;
import java.util.List;

public class QueryLexer {
    private String _query;
    private int _len = 0;
    private int _pos = 0;
    private List<LexerToken> _tokens = new ArrayList<LexerToken>();

    private LexerToken readOperator() {
        StringBuilder buf = new StringBuilder(String.valueOf(this._query.charAt(this._pos - 1)));
        block3: while (this._pos < this._len) {
            char ch = this._query.charAt(this._pos++);
            switch (ch) {
                case '<': 
                case '=': 
                case '>': {
                    buf.append(String.valueOf(ch));
                    continue block3;
                }
            }
            --this._pos;
            return new LexerToken(buf.toString(), TokenType.TT_OPERATOR);
        }
        return null;
    }

    private LexerToken readQuoted(char endChar, TokenType tokenType, TokenType tokenPrefix) {
        if (this._pos == this._len) {
            return null;
        }
        int begin = this._pos;
        StringBuilder builder = new StringBuilder();
        int bgn = this._pos;
        while (this._pos < this._len) {
            char ch;
            if ((ch = this._query.charAt(this._pos++)) == '\\') {
                builder.append(this._query, bgn, this._pos - 1);
                bgn = this._pos;
                char nch = this._query.charAt(this._pos);
                if (nch == endChar || nch == '\\') {
                    ++this._pos;
                    bgn = this._pos;
                    builder.append(nch);
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (ch != endChar) continue;
            builder.append(this._query, bgn, this._pos - 1);
            if (this._pos < this._len && this._query.charAt(this._pos) == '*') {
                ++this._pos;
                return new LexerToken(builder.toString(), tokenPrefix, begin, this._pos);
            }
            return new LexerToken(builder.toString(), tokenType, begin, this._pos);
        }
        if (bgn < this._len) {
            builder.append(this._query, bgn, this._len);
        }
        return new LexerToken(builder.toString(), tokenType, begin, this._pos);
    }

    private LexerToken readTerm() {
        boolean isNum;
        StringBuilder sb = new StringBuilder();
        int asterixCount = 0;
        int questionMarkCount = 0;
        boolean cancelLoop = false;
        int begin = this._pos;
        block6: while (this._pos < this._len && !cancelLoop) {
            char ch;
            if (Character.isWhitespace(ch = this._query.charAt(this._pos++))) {
                --this._pos;
                break;
            }
            switch (ch) {
                case '\\': {
                    if (this._pos >= this._len) {
                        return null;
                    }
                    String nch = String.valueOf(this._query.charAt(this._pos));
                    String allowedChars = "\\+-!()\"*";
                    if (!"\\+-!()\"*".contains(nch)) continue block6;
                    sb.append("\\").append(nch);
                    ++this._pos;
                    continue block6;
                }
                case '*': {
                    ++asterixCount;
                    sb.append(ch);
                    continue block6;
                }
                case '?': {
                    ++questionMarkCount;
                    sb.append(ch);
                    continue block6;
                }
                case '\"': 
                case ')': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case ']': {
                    --this._pos;
                    cancelLoop = true;
                    continue block6;
                }
            }
            sb.append(ch);
        }
        String buf = sb.toString();
        if (questionMarkCount > 0) {
            return new LexerToken(buf, TokenType.TT_TERM_WILDCARD, begin, this._pos);
        }
        if (asterixCount == 1 && buf.length() == 1) {
            return new LexerToken(buf, TokenType.TT_TERM_MATCHALL, begin, this._pos);
        }
        if (asterixCount == 1 && buf.endsWith("*")) {
            return new LexerToken(buf.substring(0, buf.length() - 1), TokenType.TT_TERM_PREFIX, begin, this._pos);
        }
        if (asterixCount > 0) {
            return new LexerToken(buf, TokenType.TT_TERM_WILDCARD, begin, this._pos);
        }
        if (buf.compareTo("AND") == 0 || buf.compareTo("&&") == 0) {
            return new LexerToken(buf, TokenType.TT_AND, begin, this._pos);
        }
        if (buf.compareTo("OR") == 0 || buf.compareTo("||") == 0) {
            return new LexerToken(buf, TokenType.TT_OR, begin, this._pos);
        }
        if (buf.compareTo("NOT") == 0) {
            return new LexerToken(buf, TokenType.TT_NOT, begin, this._pos);
        }
        boolean bl = isNum = !Double.isNaN(NumUtils.getNumeric(buf));
        if (isNum) {
            return new LexerToken(buf, TokenType.TT_TERM_NUMBER, begin, this._pos);
        }
        return new LexerToken(buf, TokenType.TT_TERM, begin, this._pos);
    }

    private LexerToken lexNextToken() {
        boolean wsPrefix = false;
        block12: while (this._pos < this._len) {
            char ch;
            if (Character.isWhitespace(ch = this._query.charAt(this._pos++))) {
                wsPrefix = true;
                continue;
            }
            LexerToken token = null;
            switch (ch) {
                case '+': {
                    token = new LexerToken(ch, TokenType.TT_PLUS);
                    break;
                }
                case '-': {
                    token = new LexerToken(ch, TokenType.TT_MINUS);
                    break;
                }
                case '!': {
                    if (this._pos > 1 && !Character.isWhitespace(this._query.charAt(this._pos - 2))) {
                        if (this._tokens.isEmpty()) break;
                        LexerToken last = this._tokens.get(this._tokens.size() - 1);
                        if (last.type == TokenType.TT_QUOTED) {
                            last.type = TokenType.TT_QUOTED_ONLY;
                            continue block12;
                        }
                        if (last.type == TokenType.TT_EXACT) {
                            last.type = TokenType.TT_EXACT_ONLY;
                            continue block12;
                        }
                        if (last.type != TokenType.TT_TERM) continue block12;
                        last.type = TokenType.TT_QUOTED_ONLY;
                        continue block12;
                    }
                    token = new LexerToken(ch, TokenType.TT_NOT);
                    break;
                }
                case '<': 
                case '=': 
                case '>': {
                    token = this.readOperator();
                    break;
                }
                case '\"': {
                    token = this.readQuoted('\"', TokenType.TT_QUOTED, TokenType.TT_QUOTED_PREFIX);
                    if (token == null || token.type != TokenType.TT_QUOTED || Double.isNaN(NumUtils.getNumeric(token.data))) break;
                    token.type = TokenType.TT_QUOTED_NUMBER;
                    break;
                }
                case '{': {
                    token = this.readQuoted('}', TokenType.TT_EXACT, TokenType.TT_EXACT_PREFIX);
                    break;
                }
                case '(': {
                    token = new LexerToken(ch, TokenType.TT_LPAREN);
                    break;
                }
                case ')': {
                    token = new LexerToken(ch, TokenType.TT_RPAREN);
                    break;
                }
                case '[': {
                    token = new LexerToken(ch, TokenType.TT_LBRACKET);
                    break;
                }
                case ']': {
                    token = new LexerToken(ch, TokenType.TT_RBRACKET);
                    break;
                }
                default: {
                    --this._pos;
                    token = this.readTerm();
                    if (token == null || token.type != TokenType.TT_TERM || !token.data.endsWith("!")) break;
                    token.data = token.data.substring(0, token.data.length() - 1);
                    token.type = TokenType.TT_QUOTED_ONLY;
                }
            }
            if (token == null) continue;
            if (wsPrefix) {
                token.setWhitespacePrefix();
            }
            return token;
        }
        return null;
    }

    private void tokenize() {
        LexerToken token;
        while ((token = this.lexNextToken()) != null) {
            this._tokens.add(token);
        }
    }

    public QueryLexer(String query) {
        this._query = query;
        this._len = query.length();
        this.tokenize();
    }

    public List<LexerToken> getTokens() {
        return this._tokens;
    }
}

