/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ITreePathIndex;
import de.cadenas.catalogsearch.lucene.index.GlobalTagMapper;
import de.cadenas.catalogsearch.lucene.index.VirtualFacetMapper;
import de.cadenas.catalogsearch.lucene.io.DocIdIndex;
import de.cadenas.catalogsearch.lucene.io.IndexManager;
import de.cadenas.catalogsearch.lucene.io.TreePathIndex;
import de.cadenas.util.Containers;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PFacetEvaluator;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;

public class IndexReaderData
implements IIndexManager.IIndexReaderData {
    private final String catalogName;
    private Set<String> usedCatalogNames;
    private final String indexPath;
    private final float boost;
    private IndexReader reader = null;
    private DocIdIndex docIdIndex = null;
    private TreePathIndex treePathIndex = null;
    private int baseDocId = -1;
    private final Object2IntMap<LeafReader> leafReaderIds = new Object2IntOpenHashMap<LeafReader>();
    private int maxDoc = 0;
    private int maxReservedDoc = 0;
    private IndexReader spellReader = null;
    private IndexReader relatedReader = null;
    private boolean cachedNumericFacets = false;
    private boolean cachedOrds = false;
    private int[] globalFacetMapping = null;
    private final List<String> numericDocFields = new ArrayList<String>();
    private static final PLogger logger = new PLogger(IndexManager.class.getSimpleName());
    private final Int2ObjectMap<List<OrdRange>> dimListsPerSegment = new Int2ObjectOpenHashMap<List<OrdRange>>();

    IndexReaderData(String catalogName, String indexPath, float boost) {
        this.catalogName = catalogName;
        this.indexPath = indexPath;
        this.boost = boost;
        this.leafReaderIds.defaultReturnValue(0);
    }

    boolean load(boolean preload, boolean onlySearchIndex, IIndexManager.IIndexIDRangeProvider docIdCounter) {
        boolean valid = false;
        try {
            this.reader = this.openIndexReader(this.catalogName, this.indexPath, preload);
            if (this.reader != null) {
                this.maxDoc = this.reader.maxDoc();
                IIndexManager.IIndexIDRangeProvider.IRange range = docIdCounter.getRange(this.maxDoc);
                this.baseDocId = range.base();
                this.maxReservedDoc = range.size();
                int leafId = 0;
                for (LeafReaderContext leafReader : this.reader.leaves()) {
                    this.leafReaderIds.put(leafReader.reader(), leafId++);
                }
                valid = true;
            } else {
                logger.warn("Can not open IndexReader (path=" + this.indexPath + "): Index does not exist");
            }
            if (!onlySearchIndex) {
                this.spellReader = this.openIndexReader(this.catalogName, this.indexPath + "/spell", false);
                this.relatedReader = this.openIndexReader(this.catalogName, this.indexPath + "/related", false);
            }
        }
        catch (IOException e) {
            logger.error("Can not open IndexReader (path=" + this.indexPath + "): " + e.toString());
            valid = false;
        }
        return valid;
    }

    private IndexReader openIndexReader(String catalogName, String indexPath, boolean preload) throws IOException {
        DirectoryReader reader = null;
        Path absoluteIndexPath = Paths.get(indexPath, new String[0]);
        if (!Files.isDirectory(absoluteIndexPath, new LinkOption[0])) {
            logger.warn("Catalog index directory doesn't exist (catalog=" + catalogName + "; index=" + indexPath + ")");
        } else {
            FSDirectory indexDirectory = FSDirectory.open(absoluteIndexPath);
            if (preload && indexDirectory instanceof MMapDirectory) {
                ((MMapDirectory)indexDirectory).setPreload(true);
            }
            reader = DirectoryReader.open(indexDirectory);
            logger.info("IndexReader loaded (path=" + indexPath + ")");
        }
        return reader;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public synchronized Set<String> getUsedCatalogNames() {
        IDocIdIndex docIdIndex;
        if (this.usedCatalogNames == null && (docIdIndex = this.getDocIdIndex()) != null) {
            this.usedCatalogNames = docIdIndex.getUsedCatalogNames();
        }
        return this.usedCatalogNames;
    }

    @Override
    public String getIndexPath() {
        return this.indexPath;
    }

    @Override
    public String getDimName(int dimIndex, int segmentId) {
        List dimList = (List)this.dimListsPerSegment.get(segmentId);
        if (dimList == null) {
            return "";
        }
        if (dimIndex >= 0 && dimIndex < dimList.size()) {
            return ((OrdRange)dimList.get((int)dimIndex)).dimName;
        }
        return "";
    }

    @Override
    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Override
    public IndexReader getSpellReader() {
        return this.spellReader;
    }

    @Override
    public IndexReader getRelatedReader() {
        return this.relatedReader;
    }

    @Override
    public synchronized IDocIdIndex getDocIdIndex() {
        if (this.docIdIndex == null) {
            Path path = Paths.get(this.indexPath, "docids.idx");
            this.docIdIndex = new DocIdIndex(this.catalogName);
            if (Files.exists(path, new LinkOption[0])) {
                this.docIdIndex.load(path.toString());
            }
        }
        return this.docIdIndex;
    }

    @Override
    public synchronized ITreePathIndex getTreePathIndex() {
        if (this.treePathIndex == null) {
            Path path = Paths.get(this.indexPath, "treepath.idx");
            this.treePathIndex = new TreePathIndex(this.catalogName);
            if (Files.exists(path, new LinkOption[0])) {
                this.treePathIndex.load(path.toString());
            }
        }
        return this.treePathIndex;
    }

    @Override
    public int getBaseDocId() {
        return this.baseDocId;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public int getLeafId(LeafReader reader) {
        return this.leafReaderIds.getInt(reader);
    }

    public int getMaxReservedDocIds() {
        return this.maxReservedDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheFacets() {
        List<String> list = this.numericDocFields;
        synchronized (list) {
            if (this.baseDocId > -1 && !this.cachedNumericFacets) {
                this.cachedNumericFacets = true;
                this.updateNumericCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheOrds() {
        List<String> list = this.numericDocFields;
        synchronized (list) {
            if (this.baseDocId > -1 && !this.cachedOrds) {
                logger.info("cacheOrds :" + this.indexPath + "," + String.valueOf(this.baseDocId) + " - " + String.valueOf(this.baseDocId + this.maxDoc));
                this.cachedOrds = true;
                this.updateOrdCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getGlobalFacetMapping() {
        List<String> list = this.numericDocFields;
        synchronized (list) {
            return this.globalFacetMapping;
        }
    }

    private void updateNumericCache() {
        FieldInfos infos = this.reader instanceof LeafReader ? ((LeafReader)this.reader).getFieldInfos() : FieldInfos.getMergedFieldInfos(this.reader);
        try {
            if (infos != null) {
                for (int i = 0; i < infos.size(); ++i) {
                    String field;
                    int docId;
                    FieldInfo info = infos.fieldInfo(i);
                    DocValuesType dvType = info.getDocValuesType();
                    if (dvType == DocValuesType.NUMERIC) {
                        Containers.IntList idList = new Containers.IntList();
                        Containers.DoubleList valueList = new Containers.DoubleList();
                        String field2 = info.name;
                        for (LeafReaderContext ctx : this.reader.leaves()) {
                            NumericDocValues docValues = DocValues.getNumeric(ctx.reader(), field2);
                            if (docValues == null) continue;
                            int parentBase = ctx.docBaseInParent;
                            docId = docValues.nextDoc();
                            while (docId != Integer.MAX_VALUE) {
                                long val = docValues.longValue();
                                double d = Double.longBitsToDouble(val);
                                idList.add(docId + this.baseDocId + parentBase);
                                valueList.add(d);
                                docId = docValues.nextDoc();
                            }
                        }
                        if (idList.isEmpty()) continue;
                        int[] idArray = idList.getData();
                        Object valueArray = valueList.getData();
                        field2 = field2.replace("facet_var_", "");
                        PFacetEvaluator.pushCacheData(field2, idArray, (double[])valueArray, idList.size());
                        this.numericDocFields.add(field2);
                        continue;
                    }
                    if (dvType != DocValuesType.BINARY || !(field = info.name).startsWith("facet_range_")) continue;
                    Containers.IntList idList = new Containers.IntList();
                    Containers.IntList indexList = new Containers.IntList();
                    Containers.DoubleList valueList = new Containers.DoubleList();
                    for (LeafReaderContext ctx : this.reader.leaves()) {
                        BinaryDocValues docValues = DocValues.getBinary(ctx.reader(), field);
                        if (docValues == null) continue;
                        docId = docValues.nextDoc();
                        while (docId != Integer.MAX_VALUE) {
                            BytesRef val = docValues.binaryValue();
                            PDataStream stream = new PDataStream(val);
                            int size = stream.readInt();
                            stream.readDouble();
                            stream.readDouble();
                            for (int j = 0; j < size; ++j) {
                                valueList.add(stream.readDouble());
                                valueList.add(stream.readDouble());
                            }
                            indexList.add(valueList.size());
                            idList.add(docId + this.baseDocId + ctx.docBaseInParent);
                            docId = docValues.nextDoc();
                        }
                    }
                    if (idList.isEmpty()) continue;
                    int[] idArray = idList.getData();
                    int[] indexArray = indexList.getData();
                    double[] valueArray = valueList.getData();
                    field = field.replace("facet_range_", "");
                    PFacetEvaluator.pushRangeData(field, idArray, indexArray, valueArray, idList.size());
                    this.numericDocFields.add(field);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateOrdCache() {
        try {
            for (LeafReaderContext ctx : this.reader.leaves()) {
                FieldInfo info;
                LeafReader leafReader = ctx.reader();
                FieldInfos infos = leafReader.getFieldInfos();
                if (infos == null || (info = infos.fieldInfo("$facets")) == null) continue;
                this.updateFieldCache(leafReader, info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFieldCache(LeafReader leafReader, FieldInfo info) throws IOException {
        if (info.getDocValuesType() == DocValuesType.SORTED_SET) {
            SortedSetDocValues docValues = leafReader.getSortedSetDocValues(info.name);
            Containers.IntList docIds = new Containers.IntList();
            Containers.IntList indexList = new Containers.IntList();
            Containers.IntList ordList = new Containers.IntList();
            byte[] facetTagsPrefix = new byte[]{102, 97, 99, 101, 116, 95, 116, 97, 103, 115, 95};
            int prefixLen = facetTagsPrefix.length;
            int valueCount = (int)docValues.getValueCount();
            boolean doublets = false;
            Seen[] valueSeen = null;
            GlobalTagMapper tagMapper = null;
            if (valueCount > 0) {
                Object2ObjectOpenHashMap<CallSite, Seen> nameToBool = new Object2ObjectOpenHashMap<CallSite, Seen>();
                for (int ord = 0; ord < valueCount; ++ord) {
                    String key;
                    Seen seen;
                    String syn;
                    String facetName;
                    int lpos;
                    BytesRef term = docValues.lookupOrd(ord);
                    if (term.length <= prefixLen || !Arrays.equals(term.bytes, term.offset, term.offset + prefixLen, facetTagsPrefix, 0, prefixLen) || (lpos = (facetName = term.utf8ToString()).indexOf("_lang", prefixLen)) == -1) continue;
                    String language = facetName.substring(prefixLen, lpos);
                    int spos = facetName.indexOf(31, lpos + 1);
                    if (spos == -1) continue;
                    String tag = facetName.substring(spos + 1).toLowerCase();
                    if (valueSeen == null) {
                        valueSeen = new Seen[valueCount];
                        tagMapper = GlobalTagMapper.getInstance();
                    }
                    if ((syn = tagMapper.getSynonymForTag(tag, language)) != null) {
                        tag = syn.toLowerCase();
                    }
                    if ((seen = (Seen)nameToBool.get(key = language + tag)) == null) {
                        seen = new Seen();
                        nameToBool.put((CallSite)((Object)key), seen);
                    } else {
                        doublets = true;
                    }
                    valueSeen[ord] = seen;
                }
            }
            if (!doublets) {
                valueSeen = null;
            }
            int docId = docValues.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                int lastIndex = ordList.size();
                long ord = docValues.nextOrd();
                while (ord != -1L) {
                    if (valueSeen != null && valueSeen[(int)ord] != null) {
                        if (valueSeen[(int)ord].docId != docId) {
                            ordList.add((int)ord);
                            valueSeen[(int)ord].docId = docId;
                        }
                    } else {
                        ordList.add((int)ord);
                    }
                    ord = docValues.nextOrd();
                }
                if (ordList.size() > lastIndex) {
                    docIds.add(docId);
                    indexList.add(ordList.size());
                }
                docId = docValues.nextDoc();
            }
            int segmentId = this.leafReaderIds.getInt(leafReader);
            PFacetEvaluator.pushOrdCache(info.name, this.baseDocId, segmentId, docIds.getData(), indexList.getData(), ordList.getData(), docIds.size());
            VirtualFacetMapper mapper = VirtualFacetMapper.getInstance();
            ArrayList<OrdRange> dimList = new ArrayList<OrdRange>();
            this.dimListsPerSegment.put(segmentId, (List<OrdRange>)dimList);
            int startOrd = -1;
            String lastDim = null;
            boolean checkVirtualFacetsForCategory = false;
            for (int ord = 0; ord < valueCount; ++ord) {
                IntArrayList virtualFacets;
                BytesRef term = docValues.lookupOrd(ord);
                String[] components = FacetsConfig.stringToPath(term.utf8ToString());
                if (components.length != 2) continue;
                if (!components[0].equals(lastDim)) {
                    String facetCategory = mapper.getCategoryPrefix();
                    boolean bl = checkVirtualFacetsForCategory = !facetCategory.isEmpty() && components[0].startsWith(facetCategory);
                    if (lastDim != null) {
                        dimList.add(new OrdRange(lastDim, startOrd, ord - 1));
                    }
                    startOrd = ord;
                    lastDim = components[0];
                }
                if (!checkVirtualFacetsForCategory) continue;
                String value = components[1];
                int dotIndex = value.indexOf(58);
                if (dotIndex != -1) {
                    value = value.substring(dotIndex + 1);
                }
                if ((virtualFacets = mapper.getVirtualFacet(value)) == null) continue;
                PFacetEvaluator.pushVirtualOrds(info.name, this.baseDocId, segmentId, ord, virtualFacets.elements(), virtualFacets.size());
            }
            if (lastDim != null) {
                dimList.add(new OrdRange(lastDim, startOrd, valueCount - 1));
            }
            if (!dimList.isEmpty()) {
                int[] categoryRanges = new int[dimList.size() * 2];
                for (int i = 0; i < dimList.size(); ++i) {
                    OrdRange r = (OrdRange)dimList.get(i);
                    categoryRanges[i * 2] = r.start;
                    categoryRanges[i * 2 + 1] = r.end;
                }
                PFacetEvaluator.pushOrdDims(info.name, this.baseDocId, segmentId, categoryRanges, categoryRanges.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupFacetCache() {
        List<String> list = this.numericDocFields;
        synchronized (list) {
            String[] fieldNames = this.numericDocFields.toArray(new String[0]);
            PFacetEvaluator.cleanupIndexReader(fieldNames, this.baseDocId, this.baseDocId + this.maxDoc);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.spellReader != null) {
                this.spellReader.close();
            }
            if (this.relatedReader != null) {
                this.relatedReader.close();
            }
        }
        catch (IOException e) {
            logger.error("Can not close IndexReader appropriately (path=" + this.indexPath + "): " + e.toString());
        }
    }

    private static class OrdRange {
        public String dimName;
        public int start;
        public int end;

        public OrdRange(String dimName, int start, int end) {
            this.dimName = dimName;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.dimName + ": " + this.start + " - " + this.end;
        }
    }

    private static class Seen {
        int docId = -1;

        private Seen() {
        }
    }
}

