/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.io.IndexManager;
import de.cadenas.catalogsearch.lucene.io.IndexReaderData;
import de.cadenas.util.PLogger;
import java.util.Map;
import org.apache.lucene.index.IndexReader;

public class IndexReaderContainer
implements IIndexManager.IIndexReaderContainer {
    private final String catalogName;
    private IndexReaderData readerData;
    private String loadingPath;
    private LoadingState loadingState;
    private static final PLogger logger = new PLogger(IndexManager.class.getSimpleName());

    IndexReaderContainer(String catalogName) {
        this.catalogName = catalogName;
        this.readerData = null;
        this.loadingPath = null;
        this.loadingState = LoadingState.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDataReader(Map<IndexReader, IndexReaderData> dataByReader, IndexReaderData readerData, IIndexManager.IIndexIDRangeProvider docIdRangeProvider) {
        IndexReader.CacheHelper cacheHelper;
        Map<IndexReader, IndexReaderData> map = dataByReader;
        synchronized (map) {
            dataByReader.put(readerData.getIndexReader(), readerData);
        }
        IndexReader reader = readerData.getIndexReader();
        if (reader != null && (cacheHelper = reader.getReaderCacheHelper()) != null) {
            cacheHelper.addClosedListener(new CloseListener(dataByReader, reader, docIdRangeProvider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadingState load(String indexPath, boolean preload, boolean onlySearchIndex, float boost, IIndexManager.IIndexIDRangeProvider docIdRangeProvider, Map<IndexReader, IndexReaderData> dataByReader) {
        IndexReaderData oldReader;
        IndexReaderData data = null;
        IndexReaderContainer indexReaderContainer = this;
        synchronized (indexReaderContainer) {
            data = this.readerData;
            if (data == null) {
                this.readerData = new IndexReaderData(this.catalogName, indexPath, boost);
                this.loadingState = LoadingState.Loaded;
                boolean valid = this.readerData.load(preload, onlySearchIndex, docIdRangeProvider);
                if (valid) {
                    this.registerDataReader(dataByReader, this.readerData, docIdRangeProvider);
                }
                this.notifyAll();
                logger.info("Load: " + this.readerData.getIndexPath());
                return LoadingState.Loaded;
            }
        }
        if (data.getIndexPath().equals(indexPath)) {
            return LoadingState.UpToDate;
        }
        indexReaderContainer = this;
        synchronized (indexReaderContainer) {
            if (this.loadingPath != null && this.loadingPath.equals(indexPath)) {
                logger.info("Already loading: " + this.loadingPath);
                return LoadingState.UpToDate;
            }
            this.loadingPath = indexPath;
        }
        IndexReaderData loading = new IndexReaderData(this.catalogName, indexPath, boost);
        boolean lvalid = loading.load(preload, onlySearchIndex, docIdRangeProvider);
        logger.info("Load: " + loading.getIndexPath());
        IndexReaderContainer indexReaderContainer2 = this;
        synchronized (indexReaderContainer2) {
            oldReader = this.readerData;
            this.readerData = loading;
            this.loadingPath = null;
            this.loadingState = LoadingState.Loaded;
            if (lvalid) {
                this.registerDataReader(dataByReader, this.readerData, docIdRangeProvider);
            }
        }
        if (oldReader != null) {
            logger.info("Close: " + oldReader.getIndexPath());
            oldReader.close();
        }
        return LoadingState.Reloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadingState unload() {
        IndexReaderData oldReader;
        IndexReaderContainer indexReaderContainer = this;
        synchronized (indexReaderContainer) {
            oldReader = this.readerData;
            this.readerData = null;
            this.loadingPath = null;
            this.loadingState = LoadingState.Unloaded;
        }
        if (oldReader != null) {
            logger.info("Close: " + oldReader.getIndexPath());
            oldReader.close();
        }
        return LoadingState.Unloaded;
    }

    private synchronized IndexReaderData getReaderData() {
        while (this.readerData == null) {
            if (this.loadingState == LoadingState.Unloaded) {
                return null;
            }
            try {
                this.wait(500L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
        }
        return this.readerData;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getIndexPath() {
        IndexReaderData data = this.getReaderData();
        if (data != null) {
            return data.getIndexPath();
        }
        return null;
    }

    @Override
    public IndexReader getIndexReader() {
        IndexReaderData data = this.getReaderData();
        if (data != null) {
            return data.getIndexReader();
        }
        return null;
    }

    public synchronized IndexReader getIndexReaderNoWait() {
        if (this.readerData != null) {
            return this.readerData.getIndexReader();
        }
        return null;
    }

    @Override
    public IndexReader getSpellReader() {
        IndexReaderData data = this.getReaderData();
        if (data != null) {
            return data.getSpellReader();
        }
        return null;
    }

    @Override
    public IndexReader getRelatedReader() {
        IndexReaderData data = this.getReaderData();
        if (data != null) {
            return data.getRelatedReader();
        }
        return null;
    }

    public void close() {
        this.getReaderData().close();
    }

    static enum LoadingState {
        None,
        UpToDate,
        Loaded,
        Reloaded,
        Unloaded;

    }

    static class CloseListener
    implements IndexReader.ClosedListener {
        private Map<IndexReader, IndexReaderData> dataByReader;
        private IndexReader reader;
        private final IIndexManager.IIndexIDRangeProvider docIdRangeProvider;

        CloseListener(Map<IndexReader, IndexReaderData> dataByReader, IndexReader reader, IIndexManager.IIndexIDRangeProvider docIdRangeProvider) {
            this.dataByReader = dataByReader;
            this.reader = reader;
            this.docIdRangeProvider = docIdRangeProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(IndexReader.CacheKey key) {
            if (this.dataByReader != null) {
                IndexReaderData readerData;
                Map<IndexReader, IndexReaderData> map = this.dataByReader;
                synchronized (map) {
                    readerData = this.dataByReader.remove(this.reader);
                }
                if (readerData != null) {
                    logger.info("Unload: " + readerData.getIndexPath());
                    readerData.cleanupFacetCache();
                    this.docIdRangeProvider.freeRange(readerData.getBaseDocId(), readerData.getMaxReservedDocIds());
                }
                this.dataByReader = null;
            }
            this.reader = null;
        }
    }
}

