/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IIndexLoadRequest;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.io.IndexIDRangeProvider;
import de.cadenas.catalogsearch.lucene.io.IndexReaderContainer;
import de.cadenas.catalogsearch.lucene.io.IndexReaderData;
import de.cadenas.catalogsearch.lucene.io.IndexTypeContainer;
import de.cadenas.catalogsearch.lucene.search.SearchResultFilter;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public class IndexManager
implements IIndexManager {
    private static final PLogger logger = new PLogger(IndexManager.class.getSimpleName());
    private final IndexTypeContainer[] typeContainers = new IndexTypeContainer[2];
    private final IndexIDRangeProvider baseDocId = new IndexIDRangeProvider();
    private final long startTime = System.currentTimeMillis();
    private final ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public IndexManager() {
        this.typeContainers[0] = new IndexTypeContainer();
        this.typeContainers[1] = new IndexTypeContainer();
    }

    @Override
    public synchronized void loadIndex(List<IIndexLoadRequest> reqList) throws Exception {
        if (reqList.isEmpty()) {
            return;
        }
        logger.info("Start-up IndexManager implementation");
        try {
            ArrayList<LoadIndexTask> tasks = new ArrayList<LoadIndexTask>();
            for (IIndexLoadRequest req : reqList) {
                IndexTypeContainer typeContainer = this.typeContainers[req.getIndexType().getIndex()];
                typeContainer.createIndexReaderContainer(req.getCatalogName(), !req.getIndexPath().isEmpty());
                tasks.add(new LoadIndexTask(req));
            }
            try {
                this.pool.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                logger.error("Index loading aborted: " + e.toString());
                throw e;
            }
            long elapsed = System.currentTimeMillis() - this.startTime;
            logger.info("Start-up done (elapsed=" + String.valueOf(elapsed) + "ms; indexes=" + reqList.size() + ")");
        }
        catch (Exception e) {
            logger.error("Start-up failed, search should not be used: " + e.toString());
            this.shutdown();
        }
    }

    @Override
    public synchronized void shutdown() throws Exception {
        logger.info("Shutting down IndexManager implementation");
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        long startTime = System.currentTimeMillis();
        try {
            for (IndexTypeContainer typeContainer : this.typeContainers) {
                typeContainer.shutdown();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            long elapsed = System.currentTimeMillis() - startTime;
            logger.info("Shutdown complete, holding no more resources (elapsed=" + String.valueOf(elapsed) + "ms)");
        }
    }

    @Override
    public IndexReader getIndexReader(FieldDefinitions.IndexType type, String path) {
        IndexTypeContainer container = this.typeContainers[type.getIndex()];
        IndexReaderContainer readerContainer = container.getIndexReaderContainer(path);
        if (readerContainer != null) {
            return readerContainer.getIndexReader();
        }
        return null;
    }

    @Override
    public Collection<IndexReader> getReadersByType(FieldDefinitions.IndexType type) {
        IndexTypeContainer container = this.typeContainers[type.getIndex()];
        return container.getAllIndexReaders();
    }

    @Override
    public Collection<String> getAllLoadedCatalogsByType(FieldDefinitions.IndexType type) {
        IndexTypeContainer container = this.typeContainers[type.getIndex()];
        return container.getAllLoadedCatalogs();
    }

    @Override
    public List<String> mapToContainingCatalogs(List<String> catalogs) {
        IndexTypeContainer container = this.typeContainers[FieldDefinitions.IndexType.Fulltext.getIndex()];
        return container.mapToContainingCatalogs(catalogs);
    }

    @Override
    public IIndexManager.IIndexReaderData findReaderData(IndexReader reader) {
        for (IndexTypeContainer typeContainer : this.typeContainers) {
            IndexReaderData data = typeContainer.getIndexReaderData(reader);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    @Override
    public IIndexManager.IndexSearcherContainerLocked createIndexSearcher(ISearchRequest searchRequest, FieldDefinitions.IndexType indexType, ExecutorService executor) throws IOException {
        List<ISearchRequest.PathFilter> pathFilters = searchRequest.getPathFilters();
        List<String> catalogList = null;
        if (pathFilters != null && !pathFilters.isEmpty()) {
            catalogList = pathFilters.size() > 1 && indexType == FieldDefinitions.IndexType.LinkDb ? pathFilters.get(1).getCatalogList() : pathFilters.get(0).getCatalogList();
        }
        if (catalogList == null || catalogList.isEmpty()) {
            return null;
        }
        SearchResultFilter filter = searchRequest.getByProjectFilter();
        if (filter != null) {
            for (int c = catalogList.size() - 1; c >= 0; --c) {
                Set<String> usedCatalogs;
                IIndexManager.IIndexReaderData readerData;
                IndexReader reader = this.getIndexReader(FieldDefinitions.IndexType.Fulltext, catalogList.get(c));
                if (reader == null || (readerData = this.findReaderData(reader)) == null || !(usedCatalogs = readerData.getUsedCatalogNames()).stream().noneMatch(cat -> filter.getCatalogFilter((String)cat) != null)) continue;
                catalogList.remove(c);
            }
        }
        IndexTypeContainer container = this.typeContainers[indexType.getIndex()];
        return container.createIndexSearcher(catalogList, indexType, executor);
    }

    @Override
    public IIndexManager.IndexSearcherContainerLocked createIndexSearcher(List<String> catalogs, FieldDefinitions.IndexType indexType, ExecutorService executor) throws IOException {
        IndexTypeContainer container = this.typeContainers[indexType.getIndex()];
        return container.createIndexSearcher(catalogs, indexType, executor);
    }

    @Override
    public SortedSetDocValuesReaderState createReaderState(IndexReader reader, FieldDefinitions.IndexType indexType, FieldDefinitions.FacetType facetType) throws IOException {
        IndexTypeContainer container = this.typeContainers[indexType.getIndex()];
        return container.createReaderState(reader, facetType);
    }

    @Override
    public void clearReaderStateCache() {
        for (IndexTypeContainer container : this.typeContainers) {
            container.clearReaderStateCache();
        }
    }

    @Override
    public IndexSearcher createSpellSearcher(List<String> catalogList, ExecutorService executor) throws IOException {
        IndexTypeContainer typeContainer = this.typeContainers[FieldDefinitions.IndexType.Fulltext.getIndex()];
        return typeContainer.createSpellSearcher(catalogList, executor);
    }

    @Override
    public IndexSearcher createRelatedWordsSearcher(List<String> catalogList, ExecutorService executor) throws IOException {
        IndexTypeContainer typeContainer = this.typeContainers[FieldDefinitions.IndexType.Fulltext.getIndex()];
        return typeContainer.createRelatedWordsSearcher(catalogList, executor);
    }

    private class LoadIndexTask
    implements Callable<Void> {
        private final IIndexLoadRequest req;

        LoadIndexTask(IIndexLoadRequest req) {
            this.req = req;
        }

        @Override
        public Void call() {
            IndexTypeContainer typeContainer = IndexManager.this.typeContainers[this.req.getIndexType().getIndex()];
            IndexReaderContainer.LoadingState state = typeContainer.load(this.req.getCatalogName(), this.req.getIndexPath(), this.req.getPreload(), this.req.getLoadOnlySearchIndex(), this.req.getBoost(), IndexManager.this.baseDocId);
            if (state == IndexReaderContainer.LoadingState.Unloaded) {
                typeContainer.removeIndexReaderContainer(this.req.getCatalogName());
            }
            return null;
        }
    }
}

